/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.logging.report;

import cn.fxbin.bubble.fireworks.plugin.logging.report.LoggingReport;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(name={"aliyunLoggingReport"})
public class LoggingReportScheduled {
    private static final Logger log = LoggerFactory.getLogger(LoggingReportScheduled.class);
    @Resource
    private LoggingReport loggingReport;
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);

    public LoggingReportScheduled() {
        executorService.scheduleAtFixedRate(() -> {
            try {
                this.loggingReport.report();
            }
            catch (Exception e) {
                log.error("\u65e5\u5fd7\u5ef6\u65f6\u6279\u91cf\u4e0a\u62a5\u5931\u8d25", (Throwable)e);
            }
        }, 2L, 10L, TimeUnit.SECONDS);
    }
}

