/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.logging.report;

import cn.fxbin.bubble.fireworks.core.util.ObjectUtils;
import cn.fxbin.bubble.fireworks.plugin.logging.cache.LoggingCache;
import cn.fxbin.bubble.fireworks.plugin.logging.constant.ReportType;
import cn.fxbin.bubble.fireworks.plugin.logging.exception.LoggingException;
import cn.fxbin.bubble.fireworks.plugin.logging.model.BubbleFireworksLogging;
import cn.fxbin.bubble.fireworks.plugin.logging.report.LoggingReport;
import cn.fxbin.bubble.fireworks.plugin.logging.util.LoggingUtils;
import com.aliyun.openservices.aliyun.log.producer.Producer;
import com.aliyun.openservices.aliyun.log.producer.Result;
import com.aliyun.openservices.aliyun.log.producer.errors.LogSizeTooLargeException;
import com.aliyun.openservices.aliyun.log.producer.errors.MaxBatchCountExceedException;
import com.aliyun.openservices.aliyun.log.producer.errors.ResultFailedException;
import com.aliyun.openservices.aliyun.log.producer.errors.TimeoutException;
import com.aliyun.openservices.log.common.LogItem;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class AliyunLoggingReport
implements LoggingReport {
    private static final Logger log = LoggerFactory.getLogger(AliyunLoggingReport.class);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 1));
    private String projectName;
    private String logStore;
    private Integer numberOfReportLog;
    private ReportType reportType;
    @Resource
    private LoggingCache loggingCache;
    private final Producer producer;

    public AliyunLoggingReport(Producer producer) {
        this.producer = producer;
    }

    @Override
    public void report() {
        block2: {
            Integer numberOfReportLog = this.getNumberOfReportLog();
            ArrayList<BubbleFireworksLogging> logs = new ArrayList();
            try {
                logs = this.loggingCache.getLogs(numberOfReportLog);
                this.report(logs);
            }
            catch (LoggingException e) {
                AliyunLoggingReport.log.error("\u65e5\u5fd7\u4e0a\u62a5\u5931\u8d25", (Throwable)e);
                if (!ObjectUtils.isNotEmpty(logs)) break block2;
                logs.forEach(log -> this.loggingCache.cache((BubbleFireworksLogging)log));
            }
        }
    }

    @Override
    public void report(List<BubbleFireworksLogging> logs) {
        if (ObjectUtils.isEmpty(logs)) {
            log.debug("Don't have logs , report logs over");
            return;
        }
        log.debug("log report start...");
        for (BubbleFireworksLogging fireworksLogging : logs) {
            LogItem logItem = LoggingUtils.generateLogItem(fireworksLogging);
            try {
                ListenableFuture listenableFuture = this.producer.send(this.getProjectName(), this.getLogStore(), logItem);
                Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new SampleFutureCallback(this.getProjectName(), this.getLogStore(), Lists.newArrayList((Object[])new LogItem[]{logItem})), (Executor)EXECUTOR_SERVICE);
            }
            catch (InterruptedException e) {
                log.warn("The current thread has been interrupted during send logs.", (Throwable)e);
            }
            catch (MaxBatchCountExceedException e) {
                log.error("The logs exceeds the maximum batch count", (Throwable)e);
            }
            catch (LogSizeTooLargeException e) {
                log.error("The size of log is larger than the maximum allowable size", (Throwable)e);
            }
            catch (TimeoutException e) {
                log.error("The time taken for allocating memory for the logs has surpassed.", (Throwable)e);
            }
            catch (Exception e) {
                log.error("Failed to send logs", (Throwable)e);
            }
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public AliyunLoggingReport setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public String getLogStore() {
        return this.logStore;
    }

    public AliyunLoggingReport setLogStore(String logStore) {
        this.logStore = logStore;
        return this;
    }

    public Integer getNumberOfReportLog() {
        return this.numberOfReportLog;
    }

    public AliyunLoggingReport setNumberOfReportLog(Integer numberOfReportLog) {
        this.numberOfReportLog = numberOfReportLog;
        return this;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public AliyunLoggingReport setReportType(ReportType reportType) {
        this.reportType = reportType;
        return this;
    }

    private static final class SampleFutureCallback
    implements FutureCallback<Result> {
        private static final Logger LOGGER = LoggerFactory.getLogger(SampleFutureCallback.class);
        private final String project;
        private final String logStore;
        private final List<LogItem> logItems;

        SampleFutureCallback(String project, String logStore, List<LogItem> logItems) {
            this.project = project;
            this.logStore = logStore;
            this.logItems = logItems;
        }

        public void onSuccess(@Nullable Result result) {
            LOGGER.info("Send logs successfully.");
        }

        public void onFailure(Throwable throwable) {
            if (throwable instanceof ResultFailedException) {
                Result result = ((ResultFailedException)throwable).getResult();
                LOGGER.error("Failed to send logs, project={}, logStore={}, result={}", new Object[]{this.project, this.logStore, result});
            } else {
                LOGGER.error("Failed to send log, e=", throwable);
            }
        }
    }
}

