/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.logging.event.runner;

import cn.fxbin.bubble.fireworks.plugin.logging.cache.LoggingCache;
import cn.fxbin.bubble.fireworks.plugin.logging.constant.ReportType;
import cn.fxbin.bubble.fireworks.plugin.logging.event.LoggingNoticeEvent;
import cn.fxbin.bubble.fireworks.plugin.logging.model.BubbleFireworksLogging;
import cn.fxbin.bubble.fireworks.plugin.logging.report.AliyunLoggingReport;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(name={"memoryLoggingCache", "aliyunLoggingReport"})
public class LoggingNoticeRunner {
    private static final Logger log = LoggerFactory.getLogger(LoggingNoticeRunner.class);
    @Resource
    private AliyunLoggingReport aliyunLoggingReport;
    @Resource(name="memoryLoggingCache")
    private LoggingCache loggingCache;

    @ConditionalOnBean(name={"aliyunLoggingReport"})
    @EventListener(value={LoggingNoticeEvent.class})
    public void run(Object object) {
        LoggingNoticeEvent event = (LoggingNoticeEvent)((Object)object);
        BubbleFireworksLogging fireworksLogging = event.getFireworksLogging();
        ReportType reportType = this.aliyunLoggingReport.getReportType();
        switch (reportType) {
            case delay: {
                this.loggingCache.cache(fireworksLogging);
                log.debug("Log cache complete.");
                break;
            }
            case realtime: {
                this.aliyunLoggingReport.report(Collections.singletonList(fireworksLogging));
                break;
            }
        }
    }
}

