/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.logging.cache;

import cn.fxbin.bubble.fireworks.core.util.ObjectUtils;
import cn.fxbin.bubble.fireworks.core.util.StringUtils;
import cn.fxbin.bubble.fireworks.plugin.logging.cache.LoggingCache;
import cn.fxbin.bubble.fireworks.plugin.logging.model.BubbleFireworksLogging;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MemoryLoggingCache
implements LoggingCache {
    private static final ConcurrentMap<String, BubbleFireworksLogging> MEMORY_CACHE_LOGS = new ConcurrentHashMap<String, BubbleFireworksLogging>();

    @Override
    public void cache(BubbleFireworksLogging fireworksLogging) {
        if (ObjectUtils.isNotEmpty((Object)fireworksLogging)) {
            MEMORY_CACHE_LOGS.put(StringUtils.getUUID(), fireworksLogging);
        }
    }

    @Override
    public List<BubbleFireworksLogging> getLogs(Integer count) {
        return this.get(count);
    }

    @Override
    public List<BubbleFireworksLogging> getAllLogs() {
        return this.get(null);
    }

    private List<BubbleFireworksLogging> get(Integer count) {
        ArrayList<BubbleFireworksLogging> logs = new ArrayList<BubbleFireworksLogging>();
        Iterator logsKey = MEMORY_CACHE_LOGS.keySet().iterator();
        int index = 0;
        while (logsKey.hasNext()) {
            String key = (String)logsKey.next();
            logs.add((BubbleFireworksLogging)MEMORY_CACHE_LOGS.get(key));
            MEMORY_CACHE_LOGS.remove(key);
            if (ObjectUtils.isNotEmpty((Object)count) && index >= count - 1) break;
            ++index;
        }
        return logs;
    }
}

