/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.logging.autoconfigure;

import cn.fxbin.bubble.fireworks.plugin.logging.constant.ReportType;
import cn.fxbin.bubble.fireworks.plugin.logging.constant.RetryStrategy;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

@RefreshScope
@ConfigurationProperties(prefix="bubble.fireworks.logging")
public class LoggingProperties {
    public static final String BUBBLE_FIREWORKS_LOGGING_PREFIX = "bubble.fireworks.logging";
    public static final String BUBBLE_FIREWORKS_LOGGING_ALIYUN_PREFIX = "bubble.fireworks.logging.aliyun";
    private boolean enabled = true;
    private ReportType reportType = ReportType.realtime;
    private Integer numberOfReportLog = 10;
    private RetryStrategy retryStrategy = RetryStrategy.discard;
    private List<String> ignoreUris;
    private AliyunLogConfig aliyun = new AliyunLogConfig();

    public boolean isEnabled() {
        return this.enabled;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public Integer getNumberOfReportLog() {
        return this.numberOfReportLog;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public List<String> getIgnoreUris() {
        return this.ignoreUris;
    }

    public AliyunLogConfig getAliyun() {
        return this.aliyun;
    }

    public LoggingProperties setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public LoggingProperties setReportType(ReportType reportType) {
        this.reportType = reportType;
        return this;
    }

    public LoggingProperties setNumberOfReportLog(Integer numberOfReportLog) {
        this.numberOfReportLog = numberOfReportLog;
        return this;
    }

    public LoggingProperties setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
        return this;
    }

    public LoggingProperties setIgnoreUris(List<String> ignoreUris) {
        this.ignoreUris = ignoreUris;
        return this;
    }

    public LoggingProperties setAliyun(AliyunLogConfig aliyun) {
        this.aliyun = aliyun;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoggingProperties)) {
            return false;
        }
        LoggingProperties other = (LoggingProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Integer this$numberOfReportLog = this.getNumberOfReportLog();
        Integer other$numberOfReportLog = other.getNumberOfReportLog();
        if (this$numberOfReportLog == null ? other$numberOfReportLog != null : !((Object)this$numberOfReportLog).equals(other$numberOfReportLog)) {
            return false;
        }
        ReportType this$reportType = this.getReportType();
        ReportType other$reportType = other.getReportType();
        if (this$reportType == null ? other$reportType != null : !((Object)((Object)this$reportType)).equals((Object)other$reportType)) {
            return false;
        }
        RetryStrategy this$retryStrategy = this.getRetryStrategy();
        RetryStrategy other$retryStrategy = other.getRetryStrategy();
        if (this$retryStrategy == null ? other$retryStrategy != null : !((Object)((Object)this$retryStrategy)).equals((Object)other$retryStrategy)) {
            return false;
        }
        List<String> this$ignoreUris = this.getIgnoreUris();
        List<String> other$ignoreUris = other.getIgnoreUris();
        if (this$ignoreUris == null ? other$ignoreUris != null : !((Object)this$ignoreUris).equals(other$ignoreUris)) {
            return false;
        }
        AliyunLogConfig this$aliyun = this.getAliyun();
        AliyunLogConfig other$aliyun = other.getAliyun();
        return !(this$aliyun == null ? other$aliyun != null : !((Object)this$aliyun).equals(other$aliyun));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoggingProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Integer $numberOfReportLog = this.getNumberOfReportLog();
        result = result * 59 + ($numberOfReportLog == null ? 43 : ((Object)$numberOfReportLog).hashCode());
        ReportType $reportType = this.getReportType();
        result = result * 59 + ($reportType == null ? 43 : ((Object)((Object)$reportType)).hashCode());
        RetryStrategy $retryStrategy = this.getRetryStrategy();
        result = result * 59 + ($retryStrategy == null ? 43 : ((Object)((Object)$retryStrategy)).hashCode());
        List<String> $ignoreUris = this.getIgnoreUris();
        result = result * 59 + ($ignoreUris == null ? 43 : ((Object)$ignoreUris).hashCode());
        AliyunLogConfig $aliyun = this.getAliyun();
        result = result * 59 + ($aliyun == null ? 43 : ((Object)$aliyun).hashCode());
        return result;
    }

    public String toString() {
        return "LoggingProperties(enabled=" + this.isEnabled() + ", reportType=" + (Object)((Object)this.getReportType()) + ", numberOfReportLog=" + this.getNumberOfReportLog() + ", retryStrategy=" + (Object)((Object)this.getRetryStrategy()) + ", ignoreUris=" + this.getIgnoreUris() + ", aliyun=" + this.getAliyun() + ")";
    }

    public static class AliyunLogConfig {
        private String projectName;
        private String logStore;
        private String endpoint;
        private String accessKeyId;
        private String accessKeySecret;

        public String getProjectName() {
            return this.projectName;
        }

        public String getLogStore() {
            return this.logStore;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public String getAccessKeySecret() {
            return this.accessKeySecret;
        }

        public AliyunLogConfig setProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public AliyunLogConfig setLogStore(String logStore) {
            this.logStore = logStore;
            return this;
        }

        public AliyunLogConfig setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public AliyunLogConfig setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public AliyunLogConfig setAccessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AliyunLogConfig)) {
                return false;
            }
            AliyunLogConfig other = (AliyunLogConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$projectName = this.getProjectName();
            String other$projectName = other.getProjectName();
            if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
                return false;
            }
            String this$logStore = this.getLogStore();
            String other$logStore = other.getLogStore();
            if (this$logStore == null ? other$logStore != null : !this$logStore.equals(other$logStore)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            String this$accessKeyId = this.getAccessKeyId();
            String other$accessKeyId = other.getAccessKeyId();
            if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
                return false;
            }
            String this$accessKeySecret = this.getAccessKeySecret();
            String other$accessKeySecret = other.getAccessKeySecret();
            return !(this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AliyunLogConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $projectName = this.getProjectName();
            result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
            String $logStore = this.getLogStore();
            result = result * 59 + ($logStore == null ? 43 : $logStore.hashCode());
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            String $accessKeyId = this.getAccessKeyId();
            result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
            String $accessKeySecret = this.getAccessKeySecret();
            result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
            return result;
        }

        public String toString() {
            return "LoggingProperties.AliyunLogConfig(projectName=" + this.getProjectName() + ", logStore=" + this.getLogStore() + ", endpoint=" + this.getEndpoint() + ", accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ")";
        }
    }
}

