/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.logging.autoconfigure;

import cn.fxbin.bubble.fireworks.plugin.logging.autoconfigure.LoggingProperties;
import cn.fxbin.bubble.fireworks.plugin.logging.cache.LoggingCache;
import cn.fxbin.bubble.fireworks.plugin.logging.cache.MemoryLoggingCache;
import cn.fxbin.bubble.fireworks.plugin.logging.report.AliyunLoggingReport;
import cn.fxbin.bubble.fireworks.plugin.logging.report.LoggingReport;
import com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.aliyun.openservices.aliyun.log.producer.Producer;
import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LoggingProperties.class})
@ConditionalOnProperty(prefix="bubble.fireworks.logging.aliyun", name={"project-name"}, matchIfMissing=false)
public class AliyunLogContextAutoConfigure {
    @Resource
    private LoggingProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public ProjectConfig projectConfig() {
        Assert.notNull((Object)this.properties.getAliyun().getProjectName(), (String)"Project Name Must defined");
        Assert.notNull((Object)this.properties.getAliyun().getEndpoint(), (String)"Aliyun Endpoint Must defined");
        Assert.notNull((Object)this.properties.getAliyun().getAccessKeyId(), (String)"AccessKeyId Must defined");
        Assert.notNull((Object)this.properties.getAliyun().getAccessKeySecret(), (String)"AccessKeySecret Must defined");
        return new ProjectConfig(this.properties.getAliyun().getProjectName(), this.properties.getAliyun().getEndpoint(), this.properties.getAliyun().getAccessKeyId(), this.properties.getAliyun().getAccessKeySecret());
    }

    @Bean
    @ConditionalOnMissingBean
    public Producer producer(@Qualifier(value="projectConfig") ProjectConfig projectConfig) {
        LogProducer producer = new LogProducer(new ProducerConfig());
        producer.putProjectConfig(projectConfig);
        return producer;
    }

    @Bean(name={"aliyunLoggingReport"})
    @ConditionalOnMissingBean(name={"aliyunLoggingReport"})
    public LoggingReport aliyunLoggingReport(@Qualifier(value="producer") Producer producer) {
        AliyunLoggingReport aliyunLoggingReport = new AliyunLoggingReport(producer);
        aliyunLoggingReport.setProjectName(this.properties.getAliyun().getProjectName());
        aliyunLoggingReport.setLogStore(this.properties.getAliyun().getLogStore());
        aliyunLoggingReport.setNumberOfReportLog(this.properties.getNumberOfReportLog());
        aliyunLoggingReport.setReportType(this.properties.getReportType());
        return aliyunLoggingReport;
    }

    @Bean(name={"memoryLoggingCache"})
    @ConditionalOnMissingBean
    public LoggingCache loggingCache() {
        return new MemoryLoggingCache();
    }
}

