/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.logging.aspect;

import cn.fxbin.bubble.fireworks.core.util.ExceptionUtils;
import cn.fxbin.bubble.fireworks.core.util.JsonUtils;
import cn.fxbin.bubble.fireworks.core.util.StringUtils;
import cn.fxbin.bubble.fireworks.core.util.WebUtils;
import cn.fxbin.bubble.fireworks.core.util.ttl.TtlMap;
import cn.fxbin.bubble.fireworks.plugin.logging.LoggingFactoryBean;
import cn.fxbin.bubble.fireworks.plugin.logging.aspect.AbstractLogging;
import cn.fxbin.bubble.fireworks.plugin.logging.event.LoggingNoticeEvent;
import cn.fxbin.bubble.fireworks.plugin.logging.model.BubbleFireworksLogging;
import cn.hutool.core.date.SystemClock;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

@Aspect
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class LoggingWebAspect
extends AbstractLogging {
    private static final Logger log = LoggerFactory.getLogger(LoggingWebAspect.class);
    @Resource
    private LoggingFactoryBean factoryBean;
    @Resource
    private ApplicationEventPublisher publisher;

    @Pointcut(value="(@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        return this.logGenerate(point);
    }

    private Object logGenerate(ProceedingJoinPoint point) throws Throwable {
        Object object;
        HttpServletResponse response = WebUtils.getResponse();
        long startNs = SystemClock.now();
        BubbleFireworksLogging fireworksLogging = this.initializeLog();
        Object[] args = point.getArgs();
        String requestBody = JsonUtils.isJsonSerialize((Object)args) ? JsonUtils.toJson((Object)args) : StringUtils.utf8Str((Object)args);
        Object responseObj = null;
        try {
            log.info("RequestUri: \u300c{}\u300d, IP: \u300c{}\u300d, Method:\u300c{}\u300d, Param:\u300c{}\u300d", new Object[]{fireworksLogging.getRequestUri(), fireworksLogging.getRequestIp(), fireworksLogging.getRequestMethod(), requestBody});
            object = responseObj = point.proceed();
        }
        catch (Exception e) {
            try {
                log.warn("exception : " + e.getMessage(), (Throwable)e);
                fireworksLogging.setExceptionStack(ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
            catch (Throwable throwable) {
                long endNs = SystemClock.now();
                long tookMs = TimeUnit.MILLISECONDS.toMillis(endNs - startNs);
                fireworksLogging.setRequestBody(requestBody).setResponseStatus(response.getStatus()).setResponseBody(JsonUtils.isJsonSerialize(responseObj) ? JsonUtils.toJson(responseObj) : StringUtils.utf8Str(responseObj)).setResponseHeaders(WebUtils.getResponseHeaders((HttpServletResponse)response)).setStartRequestTime(startNs).setEndResponseTime(endNs).setTimeConsuming(tookMs);
                this.ttlClear();
                log.info("ResponseBody: \u300c{}\u300d, ResponseStatus: \u300c{}\u300d, Consuming: \u300c{}ms\u300d", new Object[]{fireworksLogging.getResponseBody(), fireworksLogging.getResponseStatus(), fireworksLogging.getTimeConsuming()});
                this.publisher.publishEvent((ApplicationEvent)new LoggingNoticeEvent(fireworksLogging));
                throw throwable;
            }
        }
        long endNs = SystemClock.now();
        long tookMs = TimeUnit.MILLISECONDS.toMillis(endNs - startNs);
        fireworksLogging.setRequestBody(requestBody).setResponseStatus(response.getStatus()).setResponseBody(JsonUtils.isJsonSerialize((Object)responseObj) ? JsonUtils.toJson((Object)responseObj) : StringUtils.utf8Str((Object)responseObj)).setResponseHeaders(WebUtils.getResponseHeaders((HttpServletResponse)response)).setStartRequestTime(startNs).setEndResponseTime(endNs).setTimeConsuming(tookMs);
        this.ttlClear();
        log.info("ResponseBody: \u300c{}\u300d, ResponseStatus: \u300c{}\u300d, Consuming: \u300c{}ms\u300d", new Object[]{fireworksLogging.getResponseBody(), fireworksLogging.getResponseStatus(), fireworksLogging.getTimeConsuming()});
        this.publisher.publishEvent((ApplicationEvent)new LoggingNoticeEvent(fireworksLogging));
        return object;
    }

    private BubbleFireworksLogging initializeLog() {
        HttpServletRequest request = WebUtils.getRequest();
        return BubbleFireworksLogging.builder().serviceId(this.factoryBean.getServiceId()).servicePort(this.factoryBean.getServicePort()).serviceIp(this.factoryBean.getServiceIp()).spanId(this.getSpanId()).traceId(this.getTraceId()).requestIp(WebUtils.getIpAddr((HttpServletRequest)request)).requestUri(request.getRequestURI()).requestMethod(request.getMethod()).requestHeaders(WebUtils.getRequestHeaders((HttpServletRequest)request)).build();
    }

    private void ttlClear() {
        TtlMap.clear();
    }
}

