/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.logging;

import java.net.InetAddress;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class LoggingFactoryBean
implements EnvironmentAware,
InitializingBean {
    @Nullable
    private Environment environment;
    private static final String APPLICATION_NAME = "spring.application.name";
    private static final String SERVER_PORT = "server.port";
    private String serviceId;
    private String servicePort;
    private String serviceIp;

    public String getServiceId() {
        return this.serviceId;
    }

    public String getServicePort() {
        return this.servicePort;
    }

    public String getServiceIp() {
        return this.serviceIp;
    }

    public void afterPropertiesSet() throws Exception {
        this.serviceId = this.environment.getProperty(APPLICATION_NAME);
        Assert.notNull((Object)this.serviceId, (String)"Please add the \u3010spring.application.name\u3011 configuration in the application.yml or application.properties");
        this.servicePort = this.environment.getProperty(SERVER_PORT);
        Assert.notNull((Object)this.servicePort, (String)"Please add the \u3010server.port\u3011 configuration in the application.yml or application.properties");
        InetAddress inetAddress = InetAddress.getLocalHost();
        this.serviceIp = inetAddress.getHostAddress();
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

