/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.plugin.token;

import cn.fxbin.bubble.fireworks.core.util.BeanUtils;
import cn.fxbin.bubble.fireworks.core.util.CollectionUtils;
import cn.fxbin.bubble.fireworks.core.util.ObjectUtils;
import cn.fxbin.bubble.fireworks.core.util.StringUtils;
import cn.fxbin.bubble.fireworks.core.util.SystemClock;
import cn.fxbin.bubble.fireworks.core.util.time.DateUtils;
import cn.fxbin.bubble.plugin.token.exception.TokenExpiredException;
import cn.fxbin.bubble.plugin.token.model.TokenPayload;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import java.util.Map;

public class SingleJwt {
    private long expire;
    private SignatureAlgorithm algorithm;
    private Key key;

    public SingleJwt(long expire, SignatureAlgorithm algorithm, Key key) {
        this.expire = expire;
        this.algorithm = algorithm;
        this.key = key;
    }

    public SingleJwt(long expire) {
        this.expire = expire;
        this.algorithm = SignatureAlgorithm.HS512;
        this.key = Keys.secretKeyFor((SignatureAlgorithm)this.algorithm);
    }

    public SingleJwt() {
        this.algorithm = SignatureAlgorithm.HS512;
        this.key = Keys.secretKeyFor((SignatureAlgorithm)this.algorithm);
    }

    public String generateToken(String tokenType, String identity, String scope, long expire) {
        this.expire = expire;
        TokenPayload claims = TokenPayload.builder().type(tokenType).identity(identity).scope(scope).build();
        return this.generateToken(claims);
    }

    public String generateToken(String tokenType, long identity, String scope, long expire) {
        this.expire = expire;
        TokenPayload claims = TokenPayload.builder().type(tokenType).identity(String.valueOf(identity)).scope(scope).build();
        return this.generateToken(claims);
    }

    public String generateToken(String tokenType, long identity, String scope, long expire, Map<String, Object> extra) {
        this.expire = expire;
        TokenPayload claims = TokenPayload.builder().type(tokenType).identity(String.valueOf(identity)).scope(scope).extra(extra).build();
        return this.generateToken(claims);
    }

    public String generateToken(TokenPayload tokenPayload) {
        Map<String, Object> extra = tokenPayload.getExtra();
        tokenPayload.setExtra(null);
        Map claims = BeanUtils.object2Map((Object)tokenPayload);
        if (CollectionUtils.isNotEmpty(extra)) {
            extra.keySet().stream().filter(key -> ObjectUtils.isNotEmpty(extra.get(key))).forEach(key -> claims.put(key, extra.get(key)));
        }
        Date now = DateUtils.toDate((long)SystemClock.INSTANCE.currentTimeMillis());
        Date expireDate = DateUtils.toDate((long)(now.getTime() + this.expire * 1000L));
        return Jwts.builder().setId(StringUtils.getUUID()).setHeaderParam("typ", (Object)"JWT").setSubject(String.valueOf(tokenPayload.getIdentity())).setClaims(claims).setIssuedAt(now).setExpiration(expireDate).signWith(this.key).compact();
    }

    public TokenPayload parseToken(String token) {
        Map mapObj = (Map)Jwts.parserBuilder().setSigningKey(this.key).build().parse(token).getBody();
        TokenPayload payload = (TokenPayload)BeanUtils.map2Object((Map)mapObj, TokenPayload.class);
        long nowSeconds = SystemClock.INSTANCE.currentTimeMillis() / 1000L;
        if (nowSeconds > payload.getExp().longValue()) {
            throw new TokenExpiredException("token is expired");
        }
        return payload;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.algorithm;
    }

    public Long getExpire() {
        return this.expire;
    }
}

