/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.plugin.token;

import cn.fxbin.bubble.fireworks.core.util.BeanUtils;
import cn.fxbin.bubble.fireworks.core.util.CollectionUtils;
import cn.fxbin.bubble.fireworks.core.util.ObjectUtils;
import cn.fxbin.bubble.fireworks.core.util.StringUtils;
import cn.fxbin.bubble.fireworks.core.util.SystemClock;
import cn.fxbin.bubble.fireworks.core.util.time.DateUtils;
import cn.fxbin.bubble.plugin.token.exception.InvalidClaimException;
import cn.fxbin.bubble.plugin.token.exception.TokenExpiredException;
import cn.fxbin.bubble.plugin.token.model.TokenPayload;
import cn.fxbin.bubble.plugin.token.model.Tokens;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import java.util.Map;

public class DoubleJwt {
    private long accessExpire;
    private long refreshExpire;
    private SignatureAlgorithm algorithm;
    private Key key;
    private String secret;

    public DoubleJwt(long accessExpire, long refreshExpire, SignatureAlgorithm algorithm, Key key, String secret) {
        this.accessExpire = accessExpire;
        this.refreshExpire = refreshExpire;
        this.algorithm = algorithm;
        this.key = key;
        this.secret = secret;
    }

    public DoubleJwt(long accessExpire, long refreshExpire, SignatureAlgorithm algorithm, String secret) {
        this.accessExpire = accessExpire;
        this.refreshExpire = refreshExpire;
        this.algorithm = algorithm;
        this.key = Keys.hmacShaKeyFor((byte[])((byte[])Decoders.BASE64.decode((Object)secret)));
    }

    public DoubleJwt(long accessExpire, long refreshExpire, String secret) {
        this.accessExpire = accessExpire;
        this.refreshExpire = refreshExpire;
        this.algorithm = SignatureAlgorithm.HS512;
        this.key = Keys.hmacShaKeyFor((byte[])((byte[])Decoders.BASE64.decode((Object)secret)));
    }

    public String generateToken(String tokenType, String identity, String scope, long expire) {
        TokenPayload claims = TokenPayload.builder().type(tokenType).identity(identity).scope(scope).build();
        return this.generateToken(claims, expire);
    }

    public String generateToken(String tokenType, long identity, String scope, long expire) {
        TokenPayload claims = TokenPayload.builder().type(tokenType).identity(String.valueOf(identity)).scope(scope).build();
        return this.generateToken(claims, expire);
    }

    public String generateToken(String tokenType, long identity, String scope, long expire, Map<String, Object> extra) {
        return this.generateToken(tokenType, String.valueOf(identity), scope, expire, extra);
    }

    public String generateToken(String tokenType, String identity, String scope, long expire, Map<String, Object> extra) {
        TokenPayload claims = TokenPayload.builder().type(tokenType).identity(identity).scope(scope).extra(extra).build();
        return this.generateToken(claims, expire);
    }

    public String generateToken(TokenPayload tokenPayload, long expire) {
        Map<String, Object> extra = tokenPayload.getExtra();
        tokenPayload.setExtra(null);
        Map claims = BeanUtils.object2Map((Object)tokenPayload);
        if (CollectionUtils.isNotEmpty(extra)) {
            extra.keySet().stream().filter(key -> ObjectUtils.isNotEmpty(extra.get(key))).forEach(key -> claims.put(key, extra.get(key)));
        }
        Date now = DateUtils.toDate((long)SystemClock.INSTANCE.currentTimeMillis());
        Date expireDate = DateUtils.toDate((long)(now.getTime() + expire * 1000L));
        return Jwts.builder().setId(StringUtils.getUUID()).setHeaderParam("typ", (Object)"JWT").setSubject(String.valueOf(tokenPayload.getIdentity())).setClaims(claims).setIssuedAt(now).setExpiration(expireDate).signWith(this.key, this.algorithm).compact();
    }

    public TokenPayload parseToken(String token) {
        Map mapObj = (Map)Jwts.parserBuilder().setSigningKey(this.key).build().parse(token).getBody();
        TokenPayload payload = (TokenPayload)BeanUtils.map2Object((Map)mapObj, TokenPayload.class);
        this.checkTokenExpired(payload.getExp());
        return payload;
    }

    public TokenPayload parseAccessToken(String token) {
        return this.parseAccessToken(token, "bubble-fireworks");
    }

    public TokenPayload parseAccessToken(String token, String scope) {
        TokenPayload payload = this.parseToken(token);
        this.checkTokenScope(payload.getScope(), scope);
        this.checkTokenType(payload.getType(), "access");
        return payload;
    }

    public TokenPayload parseRefreshToken(String token) {
        return this.parseRefreshToken(token, "bubble-fireworks");
    }

    public TokenPayload parseRefreshToken(String token, String scope) {
        TokenPayload payload = this.parseToken(token);
        this.checkTokenScope(payload.getScope(), scope);
        this.checkTokenType(payload.getType(), "refresh");
        return payload;
    }

    private void checkTokenExpired(Integer exp) {
        long nowSeconds = SystemClock.INSTANCE.currentTimeMillis() / 1000L;
        if (nowSeconds > exp.longValue()) {
            throw new TokenExpiredException("token is expired");
        }
    }

    private void checkTokenScope(String scope, String certScope) {
        if (scope == null || !scope.equals(certScope)) {
            throw new InvalidClaimException("token scope is invalid");
        }
    }

    private void checkTokenType(String type, String accessType) {
        if (type == null || !type.equals(accessType)) {
            throw new InvalidClaimException("token type is invalid");
        }
    }

    public String generateAccessToken(long identity) {
        return this.generateToken("access", identity, "bubble-fireworks", this.accessExpire);
    }

    public String generateAccessToken(String identity) {
        return this.generateToken("access", identity, "bubble-fireworks", this.accessExpire);
    }

    public String generateRefreshToken(long identity) {
        return this.generateToken("refresh", identity, "bubble-fireworks", this.refreshExpire);
    }

    public String generateRefreshToken(String identity) {
        return this.generateToken("refresh", identity, "bubble-fireworks", this.refreshExpire);
    }

    public Tokens generateTokens(long identity) {
        return this.generateTokens(String.valueOf(identity));
    }

    public Tokens generateTokens(String identity) {
        return this.generateTokens(identity, "bubble-fireworks");
    }

    public Tokens generateTokens(long identity, String scope) {
        return this.generateTokens(String.valueOf(identity), scope, null);
    }

    public Tokens generateTokens(String identity, String scope) {
        return this.generateTokens(identity, scope, null);
    }

    public Tokens generateTokens(long identity, Map<String, Object> extra) {
        return this.generateTokens(String.valueOf(identity), "bubble-fireworks", extra);
    }

    public Tokens generateTokens(String identity, Map<String, Object> extra) {
        return this.generateTokens(identity, "bubble-fireworks", extra);
    }

    public Tokens generateTokens(String identity, String scope, Map<String, Object> extra) {
        String access = this.generateToken("access", identity, scope, this.accessExpire, extra);
        String refresh = this.generateToken("refresh", identity, scope, this.refreshExpire, extra);
        return new Tokens(access, refresh);
    }

    public SignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public Key getKey() {
        return this.key;
    }
}

