/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.lock.model;

import cn.fxbin.bubble.fireworks.core.exception.LockTimeoutException;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.LockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.handler.TimeoutHandler;
import cn.fxbin.bubble.fireworks.plugin.lock.model.LockInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ReleaseTimeoutStrategy implements TimeoutHandler
{
    NO_OPERATION{

        @Override
        public void handle(LockInfo lockInfo, LockExecutor lockExecutor) {
            log.info("already been released while lock lease time, do nothing");
        }
    }
    ,
    FAIL_FAST{

        @Override
        public void handle(LockInfo lockInfo, LockExecutor lockExecutor) {
            throw new LockTimeoutException("already been released while lock lease time , lock key is {} with lease time {} {}", new Object[]{lockInfo.getLockKey(), lockInfo.getLeaseTime(), lockInfo.getTimeUnit().name()});
        }
    };

    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(ReleaseTimeoutStrategy.class);
    }
}

