/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.lock.model;

import cn.fxbin.bubble.fireworks.core.exception.LockTimeoutException;
import cn.fxbin.bubble.fireworks.core.util.ThreadUtils;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.LockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.handler.TimeoutHandler;
import cn.fxbin.bubble.fireworks.plugin.lock.model.LockInfo;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LockTimeoutStrategy implements TimeoutHandler
{
    NO_OPERATION{

        @Override
        public void handle(LockInfo lockInfo, LockExecutor lockExecutor) {
            log.warn("try lock failed, do nothing");
        }
    }
    ,
    FAIL_FAST{

        @Override
        public void handle(LockInfo lockInfo, LockExecutor lockExecutor) {
            throw new LockTimeoutException("try lock failed, execute [FAIL_FAST Strategy], lock key is {} ", new Object[]{lockInfo.getLockKey()});
        }
    }
    ,
    RETRY{
        private final AtomicInteger count = new AtomicInteger(0);

        @Override
        public void handle(LockInfo lockInfo, LockExecutor lockExecutor) {
            while ((long)this.count.get() <= lockInfo.getRetry()) {
                if (!lockExecutor.tryLock()) continue;
                ThreadUtils.sleep((long)100L);
                this.count.incrementAndGet();
            }
            throw new LockTimeoutException("try lock retry {} times failed, lock key is {} with timeout {} {}", new Object[]{this.count.get(), lockInfo.getLockKey(), lockInfo.getWaitTime(), lockInfo.getTimeUnit().name()});
        }
    }
    ,
    BLOCK{

        @Override
        public void handle(LockInfo lockInfo, LockExecutor lockExecutor) {
            long defaultInterval = lockInfo.getWaitTime();
            long defaultMaxInterval = lockInfo.getWaitTime() * (long)Math.max(3, Runtime.getRuntime().availableProcessors());
            while (!lockExecutor.tryLock()) {
                if (defaultInterval > defaultMaxInterval) {
                    throw new LockTimeoutException("try lock failed, lock key {} use too many times, this may dead lock occurs.", new Object[]{lockInfo.getLockKey()});
                }
                try {
                    lockInfo.getTimeUnit().sleep(defaultInterval);
                    defaultInterval <<= 1;
                }
                catch (InterruptedException e) {
                    throw new LockTimeoutException("try lock failed, lock key is {} with timeout {} {}", new Object[]{lockInfo.getLockKey(), lockInfo.getWaitTime(), lockInfo.getTimeUnit().name()});
                }
            }
        }
    };

    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(LockTimeoutStrategy.class);
    }
}

