/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.lock.aop.support;

import cn.fxbin.bubble.fireworks.core.util.StringUtils;
import cn.fxbin.bubble.fireworks.plugin.lock.annotation.LockAction;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class LockKeyGenerator {
    private final ExpressionParser parser = new SpelExpressionParser();
    private final LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    public Object generate(Method method, LockAction lockAction) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getDeclaringClass().getName());
        sb.append(".").append(method.getName());
        if (lockAction.keys().length > 0 && !lockAction.keys()[0].isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>(Arrays.asList(lockAction.keys()));
            String keysStr = StringUtils.collectionToDelimitedString(keys, (String)".", (String)"", (String)"");
            sb.append(".").append(keysStr);
        }
        return sb.toString();
    }

    public String generate(String expression, Method method, Object[] args) {
        String[] parameterNames = this.discoverer.getParameterNames(method);
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < (parameterNames != null ? parameterNames.length : 0); ++i) {
            context.setVariable(parameterNames[i], args[i]);
        }
        return (String)this.parser.parseExpression(expression).getValue((EvaluationContext)context, String.class);
    }
}

