/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.lock.factory;

import cn.fxbin.bubble.fireworks.plugin.lock.executor.LockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.redis.DefaultRedisExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.redis.FairLockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.redis.MultiLockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.redis.ReadLockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.redis.RedLockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.redis.ReentrantLockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.redis.WriteLockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.model.LockInfo;
import javax.annotation.Resource;
import org.redisson.api.RedissonClient;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class LockFactory {
    @Resource(name="redisson")
    private RedissonClient redissonClient;
    @Resource
    private RedisTemplate redisTemplate;

    public LockExecutor get(LockInfo lockInfo) {
        switch (lockInfo.getLockType()) {
            case ReentrantLock: {
                return new ReentrantLockExecutor(this.redissonClient, lockInfo);
            }
            case FairLock: {
                return new FairLockExecutor(this.redissonClient, lockInfo);
            }
            case ReadLock: {
                return new ReadLockExecutor(this.redissonClient, lockInfo);
            }
            case WriteLock: {
                return new WriteLockExecutor(this.redissonClient, lockInfo);
            }
            case MultiLock: {
                return new MultiLockExecutor(this.redissonClient, lockInfo);
            }
            case RedLock: {
                return new RedLockExecutor(this.redissonClient, lockInfo);
            }
        }
        return new DefaultRedisExecutor(this.redisTemplate, lockInfo);
    }
}

