/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.lock.executor.redis;

import cn.fxbin.bubble.fireworks.plugin.lock.executor.AbstractLockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.LockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.model.LockInfo;
import org.redisson.RedissonRedLock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedLockExecutor
extends AbstractLockExecutor
implements LockExecutor {
    private static final Logger log = LoggerFactory.getLogger(RedLockExecutor.class);
    private RedissonRedLock rLock;
    private final RedissonClient redissonClient;
    private final LockInfo lockInfo;

    public RedLockExecutor(RedissonClient redissonClient, LockInfo lockInfo) {
        this.redissonClient = redissonClient;
        this.lockInfo = lockInfo;
    }

    @Override
    public boolean tryLock() {
        try {
            RLock[] lockList = new RLock[this.lockInfo.getLockKey().size()];
            for (int i = 0; i < this.lockInfo.getLockKey().size(); ++i) {
                lockList[i] = this.redissonClient.getLock(this.lockInfo.getLockKey().get(i));
            }
            this.rLock = new RedissonRedLock(lockList);
            return this.rLock.tryLock(this.lockInfo.getWaitTime().longValue(), this.lockInfo.getLeaseTime().longValue(), this.lockInfo.getTimeUnit());
        }
        catch (InterruptedException e) {
            log.error("\u52a0\u9501\u5931\u8d25\u4fe1\u606f\uff0c{}", (Object)this.lockInfo);
            log.error("\u52a0\u9501\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean releaseLock(LockInfo lockInfo) {
        return this.isHeldByCurrentThread(lockInfo, (RLock)this.rLock);
    }
}

