/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.lock.executor.redis;

import cn.fxbin.bubble.fireworks.plugin.lock.executor.AbstractLockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.LockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.model.LockInfo;
import java.util.concurrent.ExecutionException;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadLockExecutor
extends AbstractLockExecutor
implements LockExecutor {
    private static final Logger log = LoggerFactory.getLogger(ReadLockExecutor.class);
    private RReadWriteLock rLock;
    private final RedissonClient redissonClient;
    private final LockInfo lockInfo;

    public ReadLockExecutor(RedissonClient redissonClient, LockInfo lockInfo) {
        this.redissonClient = redissonClient;
        this.lockInfo = lockInfo;
    }

    @Override
    public boolean tryLock() {
        try {
            this.rLock = this.redissonClient.getReadWriteLock(this.getLockKey(this.lockInfo.getLockKey()));
            return this.rLock.readLock().tryLock(this.lockInfo.getWaitTime().longValue(), this.lockInfo.getLeaseTime().longValue(), this.lockInfo.getTimeUnit());
        }
        catch (InterruptedException e) {
            log.error("\u52a0\u9501\u5931\u8d25\u4fe1\u606f\uff0c{}", (Object)this.lockInfo);
            log.error("\u52a0\u9501\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean releaseLock(LockInfo lockInfo) {
        if (this.rLock.readLock().isHeldByCurrentThread()) {
            try {
                return (Boolean)this.rLock.readLock().forceUnlockAsync().get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("\u91ca\u653e\u9501\u5931\u8d25\u4fe1\u606f\uff0c{}", (Object)lockInfo);
                log.error("\u91ca\u653e\u9501\u5931\u8d25", (Throwable)e);
                return false;
            }
        }
        return false;
    }
}

