/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.lock.executor.redis;

import cn.fxbin.bubble.fireworks.core.util.StringUtils;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.AbstractLockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.LockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.model.LockInfo;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class DefaultRedisExecutor
extends AbstractLockExecutor
implements LockExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultRedisExecutor.class);
    private static final RedisScript<String> SCRIPT_LOCK = new DefaultRedisScript("return redis.call('set',KEYS[1],ARGV[1],'NX','PX',ARGV[2])", String.class);
    private static final RedisScript<String> SCRIPT_UNLOCK = new DefaultRedisScript("if redis.call('get',KEYS[1]) == ARGV[1] then return tostring(redis.call('del', KEYS[1])==1) else return 'false' end", String.class);
    private static final String LOCK_SUCCESS = "OK";
    private final RedisTemplate redisTemplate;
    private final LockInfo lockInfo;

    public DefaultRedisExecutor(RedisTemplate redisTemplate, LockInfo lockInfo) {
        this.redisTemplate = redisTemplate;
        this.lockInfo = lockInfo;
    }

    @Override
    public boolean tryLock() {
        String locked = (String)this.redisTemplate.execute(SCRIPT_LOCK, this.redisTemplate.getStringSerializer(), this.redisTemplate.getStringSerializer(), Collections.singletonList(this.getLockKey(this.lockInfo.getLockKey())), new Object[]{this.lockInfo.getLockValue(), StringUtils.utf8Str((Object)this.lockInfo.getLeaseTime())});
        return LOCK_SUCCESS.equalsIgnoreCase(locked);
    }

    @Override
    public boolean releaseLock(LockInfo lockInfo) {
        Object execute = this.redisTemplate.execute(SCRIPT_UNLOCK, this.redisTemplate.getStringSerializer(), this.redisTemplate.getStringSerializer(), Collections.singletonList(this.getLockKey(lockInfo.getLockKey())), new Object[]{lockInfo.getLockValue()});
        assert (execute != null);
        return Boolean.parseBoolean(execute.toString());
    }
}

