/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.lock.executor;

import cn.fxbin.bubble.fireworks.plugin.lock.model.LockInfo;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class AbstractLockExecutor {
    private static final Logger log = LoggerFactory.getLogger(AbstractLockExecutor.class);

    public String getLockKey(List<String> lockKeyList) {
        Assert.notEmpty(lockKeyList, (String)"lock key list is not allowed empty");
        return lockKeyList.get(0);
    }

    public boolean isHeldByCurrentThread(LockInfo lockInfo, RLock rLock) {
        if (rLock.isHeldByCurrentThread()) {
            try {
                return (Boolean)rLock.forceUnlockAsync().get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("\u91ca\u653e\u9501\u5931\u8d25\u4fe1\u606f\uff0c{}", (Object)lockInfo);
                log.error("\u91ca\u653e\u9501\u5931\u8d25", (Throwable)e);
                return false;
            }
        }
        return false;
    }
}

