/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.lock.aop.support;

import cn.fxbin.bubble.fireworks.core.util.AnnotationUtils;
import cn.fxbin.bubble.fireworks.core.util.ArrayUtils;
import cn.fxbin.bubble.fireworks.core.util.CollectionUtils;
import cn.fxbin.bubble.fireworks.core.util.ObjectUtils;
import cn.fxbin.bubble.fireworks.core.util.RunTimeUtils;
import cn.fxbin.bubble.fireworks.core.util.StringUtils;
import cn.fxbin.bubble.fireworks.plugin.lock.annotation.LockAction;
import cn.fxbin.bubble.fireworks.plugin.lock.aop.support.LockKeyGenerator;
import cn.fxbin.bubble.fireworks.plugin.lock.executor.LockExecutor;
import cn.fxbin.bubble.fireworks.plugin.lock.factory.LockFactory;
import cn.fxbin.bubble.fireworks.plugin.lock.model.LockInfo;
import cn.fxbin.bubble.fireworks.plugin.lock.model.LockKeyGeneratorStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;

@Aspect
@Order(value=-1)
public class LockActionAspect {
    private static final Logger log = LoggerFactory.getLogger(LockActionAspect.class);
    private static final LockKeyGenerator KEY_GENERATOR = new LockKeyGenerator();
    @Resource
    private LockFactory lockFactory;

    @Pointcut(value="@annotation(cn.fxbin.bubble.fireworks.plugin.lock.annotation.LockAction)")
    public void pointCut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object object;
        LockInfo lockInfo = null;
        LockExecutor lockExecutor = null;
        try {
            String[] stringArray;
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            LockAction lockAction = methodSignature.getMethod().getAnnotation(LockAction.class);
            String lockName = this.getKey(methodSignature.getMethod(), lockAction, point);
            String lockValue = RunTimeUtils.getPid() + ":" + StringUtils.getUUID();
            LockInfo.LockInfoBuilder lockInfoBuilder = LockInfo.builder();
            if (ObjectUtils.isEmpty((Object[])lockAction.keys())) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = lockName;
            } else if (lockAction.keys().length > 1) {
                stringArray = lockAction.keys();
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = lockName;
            }
            lockInfo = lockInfoBuilder.lockKey(CollectionUtils.arrayToList((Object)stringArray)).lockValue(lockValue).lockType(lockAction.lockType()).leaseTime(lockAction.leaseTime()).waitTime(lockAction.waitTime()).timeUnit(lockAction.timeUnit()).retry(lockAction.retry()).lockTimeoutStrategy(lockAction.lockTimeoutStrategy()).releaseTimeoutStrategy(lockAction.releaseTimeoutStrategy()).build();
            lockExecutor = this.lockFactory.get(lockInfo);
            boolean locked = lockExecutor.tryLock();
            if (!locked) {
                lockInfo.getLockTimeoutStrategy().handle(lockInfo, lockExecutor);
            }
            log.info("{} \u52a0\u9501\u6210\u529f", lockInfo.getLockKey());
            object = point.proceed();
        }
        catch (Throwable throwable) {
            Assert.notNull(lockInfo, (String)"lockinfo is not allowed null");
            Assert.notNull(lockExecutor, (String)"lockExecutor is not allowed null");
            if (!lockExecutor.releaseLock(lockInfo)) {
                lockInfo.getReleaseTimeoutStrategy().handle(lockInfo, lockExecutor);
            }
            throw throwable;
        }
        Assert.notNull((Object)lockInfo, (String)"lockinfo is not allowed null");
        Assert.notNull((Object)lockExecutor, (String)"lockExecutor is not allowed null");
        if (!lockExecutor.releaseLock(lockInfo)) {
            lockInfo.getReleaseTimeoutStrategy().handle(lockInfo, lockExecutor);
        }
        return object;
    }

    private String getKey(Method method, LockAction lockAction, ProceedingJoinPoint point) {
        if (ArrayUtils.isEmpty((Object)lockAction.keys()) || "".equals(lockAction.keys()[0])) {
            AnnotationUtils.setValue((Annotation)lockAction, (String)"keyGeneratorType", (Object)((Object)LockKeyGeneratorStrategy.Sample));
        }
        switch (lockAction.keyGeneratorType()) {
            case Expression: {
                return KEY_GENERATOR.generate(lockAction.keys()[0], method, point.getArgs());
            }
        }
        return (String)KEY_GENERATOR.generate(method, lockAction);
    }
}

