/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.converters.time;

import cn.fxbin.bubble.fireworks.core.util.ObjectUtils;
import cn.fxbin.bubble.fireworks.core.util.time.DateUtils;
import com.alibaba.excel.annotation.format.LocalDateTimeFormat;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.time.LocalDateTime;

public class LocalDateTimeStringConverter
implements Converter<LocalDateTime> {
    public Class supportJavaTypeKey() {
        return LocalDateTime.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public LocalDateTime convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        LocalDateTimeFormat annotation = contentProperty.getField().getAnnotation(LocalDateTimeFormat.class);
        return DateUtils.parseLocalDateTime((String)DateUtils.formatDateText((String)cellData.getStringValue()), (String)(ObjectUtils.isEmpty((Object)annotation) ? "yyyy-MM-dd HH:mm:ss" : annotation.value()));
    }

    public CellData convertToExcelData(LocalDateTime value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        LocalDateTimeFormat annotation = contentProperty.getField().getAnnotation(LocalDateTimeFormat.class);
        return new CellData(DateUtils.format((LocalDateTime)value, (String)(ObjectUtils.isEmpty((Object)annotation) ? "yyyy-MM-dd HH:mm:ss.SSS" : annotation.value())));
    }
}

