/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.plugin.excel.listener;

import cn.fxbin.bubble.fireworks.core.util.JsonUtils;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExcelListener<M>
extends AnalysisEventListener<M> {
    private static final Logger log = LoggerFactory.getLogger(AbstractExcelListener.class);
    private static final int BATCH_COUNT = 3000;
    private final boolean isContinueAfterThrowing = true;
    List<M> list = new ArrayList<M>();

    public abstract void doService();

    public void invoke(M object, AnalysisContext context) {
        this.list.add(object);
        if (this.list.size() >= 3000) {
            this.doService();
            this.list = new ArrayList<M>(3000);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        this.doService();
        this.list.clear();
        log.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        log.error("\u89e3\u6790\u5931\u8d25\uff0c\u662f\u5426\u7ee7\u7eed\u89e3\u6790\u4e0b\u4e00\u884c:[{}]\uff0c msg:[{}]", (Object)true, (Object)exception.getMessage());
        if (exception instanceof ExcelDataConvertException) {
            ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
            log.error("\u7b2c {} Sheet\u9875\uff0c\u7b2c{}\u884c\uff0c\u7b2c{}\u5217\u89e3\u6790\u5f02\u5e38", new Object[]{excelDataConvertException.getRowIndex(), excelDataConvertException.getRowIndex(), excelDataConvertException.getColumnIndex()});
        }
    }

    public boolean hasNext(AnalysisContext context) {
        return super.hasNext(context);
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        log.info("\u89e3\u6790\u5230\u4e00\u6761\u5934\u6570\u636e:{}", (Object)JsonUtils.toJson(headMap));
    }
}

