/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.example.config;

import cn.futuai.open.encrypt.spring.cloud.gateway.callback.GatewayApiExceptionCallbackManager;
import cn.futuai.open.encrypt.spring.cloud.gateway.exception.handler.GatewayApiExceptionRequestHandler;
import cn.hutool.json.JSONUtil;
import org.reactivestreams.Publisher;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Configuration
public class ApiEncryptConfiguration {
    public ApiEncryptConfiguration() {
        GatewayApiExceptionCallbackManager.setApiExceptionHandler((GatewayApiExceptionRequestHandler)new GatewayApiExceptionRequestHandler(){

            public Mono<ServerResponse> handleRequest(ServerWebExchange serverWebExchange, Throwable throwable) {
                Response<Void> error = Response.create(ResponseTypeEnum.PARAM_VALID_ERROR);
                String errJson = JSONUtil.toJsonStr(error);
                return ServerResponse.ok().contentType(MediaType.APPLICATION_JSON).body((Publisher)Mono.just((Object)errJson), String.class);
            }
        });
    }

    public static enum ResponseTypeEnum {
        SUCCESS("00000", "\u6210\u529f"),
        SYSTEM_ERROR("00001", "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5", true),
        PARAM_VALID_ERROR("00002", "\u53c2\u6570\u6821\u9a8c\u9519\u8bef", true);

        private final String code;
        private final String message;
        private final boolean printException;
        private final Response<Void> voidResponse;

        private ResponseTypeEnum(String code, String message, boolean printException) {
            this.code = code;
            this.message = message;
            this.printException = printException;
            this.voidResponse = Response.create(this);
        }

        private ResponseTypeEnum(String code, String message) {
            this.code = code;
            this.message = message;
            this.printException = false;
            this.voidResponse = Response.create(this);
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isPrintException() {
            return this.printException;
        }

        public Response<Void> getVoidResponse() {
            return this.voidResponse;
        }
    }

    public static class Response<T> {
        private String code;
        private String message;
        private T data;

        public static Response<Void> create(ResponseTypeEnum responseType) {
            if (responseType == null) {
                return ResponseTypeEnum.SYSTEM_ERROR.getVoidResponse();
            }
            return new Response<Object>(responseType.getCode(), responseType.getMessage(), null);
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public T getData() {
            return this.data;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setData(T data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            T this$data = this.getData();
            T other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            T $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "ApiEncryptConfiguration.Response(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
        }

        public Response() {
        }

        public Response(String code, String message, T data) {
            this.code = code;
            this.message = message;
            this.data = data;
        }
    }
}

