/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.cloud.gateway.filter.response;

import cn.futuai.open.encrypt.core.exception.ApiEncryptException;
import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.cloud.gateway.config.property.GatewayApiEncryptProperties;
import cn.futuai.open.encrypt.spring.cloud.gateway.filter.AbstractGatewayFilter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.rewrite.ModifyResponseBodyGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.RewriteFunction;
import org.springframework.http.MediaType;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GatewayResponseEncryptFilter
extends AbstractGatewayFilter {
    @Resource
    private ModifyResponseBodyGatewayFilterFactory encryptFilterFactory;
    @Resource
    private GatewayApiEncryptProperties gatewayApiEncryptProperty;

    @Override
    protected GatewayApiEncryptProperties getGatewayApiEncryptProperty() {
        return this.gatewayApiEncryptProperty;
    }

    @Override
    protected Mono<Void> doFilterInternal(ServerWebExchange exchange, GatewayFilterChain chain) {
        String requestUri = exchange.getRequest().getURI().getPath();
        if (ApiChecker.isPass((String)requestUri, (Boolean)this.gatewayApiEncryptProperty.getResponseEncrypt().getEnabled(), (CheckModel)this.gatewayApiEncryptProperty.getResponseEncrypt().getCheckModel())) {
            return chain.filter(exchange);
        }
        return this.encryptFilterFactory.apply(new ModifyResponseBodyGatewayFilterFactory.Config().setRewriteFunction(byte[].class, byte[].class, (RewriteFunction)new ResponseEncryptRewriter())).filter(exchange, chain);
    }

    public int getOrder() {
        return -2;
    }

    static class ResponseEncryptRewriter
    implements RewriteFunction<byte[], byte[]> {
        ResponseEncryptRewriter() {
        }

        public Publisher<byte[]> apply(ServerWebExchange exchange, byte[] bytes) {
            if (!MediaType.APPLICATION_JSON.equals((Object)exchange.getResponse().getHeaders().getContentType())) {
                return Mono.just((Object)bytes);
            }
            return Mono.just((Object)this.encrypt(exchange, bytes));
        }

        private byte[] encrypt(ServerWebExchange exchange, byte[] jsonBytes) {
            String encryptResult;
            String aesKey = (String)exchange.getAttribute("aesKey");
            if (ArrayUtil.isEmpty((byte[])jsonBytes) || StrUtil.isBlank((CharSequence)aesKey)) {
                return jsonBytes;
            }
            String requestUri = exchange.getRequest().getURI().getPath();
            String json = new String(jsonBytes);
            try {
                encryptResult = ApiEncryptUtil.aesEncrypt((String)json, (String)aesKey);
            }
            catch (Exception e) {
                throw new ApiEncryptException(requestUri, json, aesKey, (Throwable)e);
            }
            return encryptResult.getBytes(StandardCharsets.UTF_8);
        }
    }
}

