/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.cloud.gateway.filter.request;

import cn.futuai.open.encrypt.core.exception.ApiTimestampException;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.cloud.gateway.config.property.GatewayApiEncryptProperties;
import cn.futuai.open.encrypt.spring.cloud.gateway.filter.AbstractGatewayFilter;
import cn.hutool.core.util.StrUtil;
import javax.annotation.Resource;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GatewayRequestApiTimestampVerifyFilter
extends AbstractGatewayFilter {
    @Resource
    private GatewayApiEncryptProperties gatewayApiEncryptProperty;

    @Override
    protected GatewayApiEncryptProperties getGatewayApiEncryptProperty() {
        return this.gatewayApiEncryptProperty;
    }

    @Override
    protected Mono<Void> doFilterInternal(ServerWebExchange exchange, GatewayFilterChain chain) {
        String requestUri = exchange.getRequest().getURI().getPath();
        String timestampStr = (String)exchange.getAttribute("timestamp");
        if (StrUtil.isBlankIfStr((Object)timestampStr) || !StrUtil.isNumeric((CharSequence)timestampStr)) {
            throw new ApiTimestampException(requestUri, timestampStr);
        }
        long timestamp = Long.parseLong(timestampStr);
        if (!ApiEncryptUtil.isTimestampValid((long)timestamp, (long)this.gatewayApiEncryptProperty.getTimestamp().getTimestampValidSecond())) {
            throw new ApiTimestampException(requestUri, timestampStr);
        }
        return chain.filter(exchange);
    }

    public int getOrder() {
        return -2147483638;
    }
}

