/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.cloud.gateway.filter;

import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.spring.cloud.gateway.config.property.GatewayApiEncryptProperties;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractGatewayFilter
implements GlobalFilter,
Ordered {
    protected abstract GatewayApiEncryptProperties getGatewayApiEncryptProperty();

    protected abstract Mono<Void> doFilterInternal(ServerWebExchange var1, GatewayFilterChain var2);

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        GatewayApiEncryptProperties gatewayApiEncryptProperty;
        String requestUri = exchange.getRequest().getURI().getPath();
        if (ApiChecker.isPass((String)requestUri, (Boolean)(gatewayApiEncryptProperty = this.getGatewayApiEncryptProperty()).getEnabled(), (CheckModel)gatewayApiEncryptProperty.getCheckModel())) {
            return chain.filter(exchange);
        }
        String encryptAesKey = exchange.getRequest().getHeaders().getFirst(gatewayApiEncryptProperty.getEncryptAesKeyHeaderKey());
        if (ApiChecker.isTolerantRequest((String)requestUri, (List)gatewayApiEncryptProperty.getTolerantUrls(), (String)encryptAesKey)) {
            return chain.filter(exchange);
        }
        return this.doFilterInternal(exchange, chain);
    }
}

