/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.cloud.gateway.exception.handler.impl;

import cn.futuai.open.encrypt.spring.cloud.gateway.exception.handler.GatewayApiExceptionRequestHandler;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class DefaultGatewayApiExceptionRequestHandler
implements GatewayApiExceptionRequestHandler {
    private static final String DEFAULT_EXCEPTION_MSG = "invalid param: ";

    @Override
    public Mono<ServerResponse> handleRequest(ServerWebExchange exchange, Throwable ex) {
        if (this.acceptsHtml(exchange)) {
            return this.htmlErrorResponse(ex);
        }
        return ServerResponse.status((HttpStatus)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)this.buildErrorResult(ex)));
    }

    private Mono<ServerResponse> htmlErrorResponse(Throwable ex) {
        return ServerResponse.status((HttpStatus)HttpStatus.FORBIDDEN).contentType(MediaType.TEXT_PLAIN).bodyValue((Object)(DEFAULT_EXCEPTION_MSG + ex.getClass().getSimpleName()));
    }

    private ErrorResult buildErrorResult(Throwable ex) {
        return new ErrorResult(HttpStatus.FORBIDDEN.value(), DEFAULT_EXCEPTION_MSG + ex.getClass().getSimpleName());
    }

    private boolean acceptsHtml(ServerWebExchange exchange) {
        try {
            List acceptedMediaTypes = exchange.getRequest().getHeaders().getAccept();
            acceptedMediaTypes.remove(MediaType.ALL);
            MediaType.sortBySpecificityAndQuality((List)acceptedMediaTypes);
            return acceptedMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)MediaType.TEXT_HTML).isCompatibleWith(arg_0));
        }
        catch (InvalidMediaTypeException ex) {
            return false;
        }
    }

    private static class ErrorResult {
        private final int code;
        private final String message;

        ErrorResult(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

