/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.cloud.gateway.exception;

import cn.futuai.open.encrypt.core.exception.ApiBaseException;
import cn.futuai.open.encrypt.core.log.ApiEncryptLogger;
import cn.futuai.open.encrypt.spring.cloud.gateway.callback.GatewayApiExceptionCallbackManager;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

public class GatewayApiExceptionHandler
implements WebExceptionHandler {
    private final List<ViewResolver> viewResolvers;
    private final List<HttpMessageWriter<?>> messageWriters;
    private final ApiEncryptLogger apiEncryptLogger;
    private final Supplier<ServerResponse.Context> contextSupplier = () -> new ServerResponse.Context(){

        public List<HttpMessageWriter<?>> messageWriters() {
            return GatewayApiExceptionHandler.this.messageWriters;
        }

        public List<ViewResolver> viewResolvers() {
            return GatewayApiExceptionHandler.this.viewResolvers;
        }
    };

    public GatewayApiExceptionHandler(List<ViewResolver> viewResolvers, ServerCodecConfigurer serverCodecConfigurer, ApiEncryptLogger apiEncryptLogger) {
        this.viewResolvers = viewResolvers;
        this.messageWriters = serverCodecConfigurer.getWriters();
        this.apiEncryptLogger = apiEncryptLogger;
    }

    private Mono<Void> writeResponse(ServerResponse response, ServerWebExchange exchange) {
        return response.writeTo(exchange, this.contextSupplier.get());
    }

    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        if (exchange.getResponse().isCommitted()) {
            return Mono.error((Throwable)ex);
        }
        if (!(ex instanceof ApiBaseException)) {
            return Mono.error((Throwable)ex);
        }
        this.logApiException(ex);
        return this.handleApiExceptionRequest(exchange, ex).flatMap(response -> this.writeResponse((ServerResponse)response, exchange));
    }

    private void logApiException(Throwable throwable) {
        this.apiEncryptLogger.logException(throwable);
    }

    private Mono<ServerResponse> handleApiExceptionRequest(ServerWebExchange exchange, Throwable throwable) {
        return GatewayApiExceptionCallbackManager.getApiExceptionHandler().handleRequest(exchange, throwable);
    }
}

