/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.cloud.gateway.filter.request;

import cn.futuai.open.encrypt.core.exception.ApiDecryptException;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.cloud.gateway.config.property.GatewayApiEncryptProperties;
import cn.futuai.open.encrypt.spring.cloud.gateway.filter.AbstractGatewayFilter;
import cn.hutool.core.util.StrUtil;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GatewayRequestApiFilter
extends AbstractGatewayFilter {
    @Resource
    private GatewayApiEncryptProperties gatewayApiEncryptProperty;

    @Override
    protected GatewayApiEncryptProperties getGatewayApiEncryptProperty() {
        return this.gatewayApiEncryptProperty;
    }

    @Override
    protected Mono<Void> doFilterInternal(ServerWebExchange exchange, GatewayFilterChain chain) {
        String encryptAesKey;
        String orgQueryString;
        String timestamp;
        ServerHttpRequest request = exchange.getRequest();
        String requestUri = request.getURI().getPath();
        String sign = request.getHeaders().getFirst(this.gatewayApiEncryptProperty.getSignHeaderKey());
        if (StrUtil.isNotBlank((CharSequence)sign)) {
            exchange.getAttributes().put("sign", sign);
        }
        if (StrUtil.isNotBlank((CharSequence)(timestamp = request.getHeaders().getFirst(this.gatewayApiEncryptProperty.getTimestampHeaderKey())))) {
            exchange.getAttributes().put("timestamp", timestamp);
        }
        if (StrUtil.isNotBlank((CharSequence)(orgQueryString = request.getURI().getQuery()))) {
            exchange.getAttributes().put("orgQueryString", orgQueryString);
        }
        if (StrUtil.isNotBlank((CharSequence)(encryptAesKey = request.getHeaders().getFirst(this.gatewayApiEncryptProperty.getEncryptAesKeyHeaderKey())))) {
            try {
                String aseKey = ApiEncryptUtil.rsaDecrypt((String)encryptAesKey);
                exchange.getAttributes().put("aesKey", aseKey);
            }
            catch (Exception e) {
                throw new ApiDecryptException(requestUri, encryptAesKey, "", (Throwable)e);
            }
        }
        if (request.getMethod() == HttpMethod.GET) {
            return chain.filter(exchange);
        }
        DefaultDataBufferFactory defaultDataBufferFactory = new DefaultDataBufferFactory();
        DefaultDataBuffer defaultDataBuffer = defaultDataBufferFactory.allocateBuffer(0);
        return DataBufferUtils.join((Publisher)request.getBody().defaultIfEmpty((Object)defaultDataBuffer)).flatMap(dataBuffer -> {
            DataBufferUtils.retain((DataBuffer)dataBuffer);
            final Flux cachedFlux = Flux.defer(() -> Flux.just((Object)dataBuffer.slice(0, dataBuffer.readableByteCount())));
            ServerHttpRequestDecorator mutatedRequest = new ServerHttpRequestDecorator(request){

                public Flux<DataBuffer> getBody() {
                    return cachedFlux;
                }
            };
            return this.getBody(exchange.mutate().request((ServerHttpRequest)mutatedRequest).build(), chain);
        });
    }

    private Mono<Void> getBody(ServerWebExchange exchange, GatewayFilterChain chain) {
        Mono bodyMono = exchange.getRequest().getBody().map(dataBuffer -> {
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            DataBufferUtils.release((DataBuffer)dataBuffer);
            return new String(bytes, StandardCharsets.UTF_8);
        }).reduce(String::concat);
        return bodyMono.flatMap(body -> {
            if (StrUtil.isNotBlank((CharSequence)body)) {
                exchange.getAttributes().put("orgBody", body);
            }
            return chain.filter(exchange);
        });
    }

    public int getOrder() {
        return -2147483643;
    }
}

