/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.cloud.gateway.filter.request;

import cn.futuai.open.encrypt.core.exception.ApiDecryptException;
import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.property.RequestDecrypt;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.cloud.gateway.config.property.GatewayApiEncryptProperties;
import cn.futuai.open.encrypt.spring.cloud.gateway.filter.AbstractGatewayFilter;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.rewrite.ModifyRequestBodyGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.RewriteFunction;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GatewayRequestApiDecryptFilter
extends AbstractGatewayFilter {
    @Resource
    private ModifyRequestBodyGatewayFilterFactory encryptFilterFactory;
    @Resource
    private GatewayApiEncryptProperties gatewayApiEncryptProperty;

    @Override
    protected GatewayApiEncryptProperties getGatewayApiEncryptProperty() {
        return this.gatewayApiEncryptProperty;
    }

    @Override
    protected Mono<Void> doFilterInternal(ServerWebExchange exchange, GatewayFilterChain chain) {
        RequestDecrypt requestDecrypt;
        ServerHttpRequest request = exchange.getRequest();
        String requestUri = request.getURI().getPath();
        if (ApiChecker.isPass((String)requestUri, (Boolean)(requestDecrypt = this.gatewayApiEncryptProperty.getRequestDecrypt()).getEnabled(), (CheckModel)requestDecrypt.getCheckModel())) {
            return chain.filter(exchange);
        }
        String queryString = (String)exchange.getAttribute("orgQueryString");
        String aesKey = (String)exchange.getAttribute("aesKey");
        try {
            String decryptRequestParam = this.decryptRequestParam(queryString, aesKey);
            this.updateRequestParam(exchange, decryptRequestParam);
        }
        catch (Exception e) {
            throw new ApiDecryptException(requestUri, queryString, aesKey, (Throwable)e);
        }
        String orgBody = (String)exchange.getAttribute("orgBody");
        if (StrUtil.isBlank((CharSequence)orgBody)) {
            return chain.filter(exchange);
        }
        return this.encryptFilterFactory.apply(new ModifyRequestBodyGatewayFilterFactory.Config().setRewriteFunction(byte[].class, byte[].class, (RewriteFunction)new RequestDecryptRewriter())).filter(exchange, chain);
    }

    public int getOrder() {
        return -2147483618;
    }

    private String decryptRequestParam(String queryString, String aesKey) {
        if (StrUtil.isNotBlank((CharSequence)queryString) && queryString.contains(this.gatewayApiEncryptProperty.getEncryptParamKey())) {
            String[] split = queryString.split("=");
            String paramValue = split[1];
            return ApiEncryptUtil.aesDecrypt((String)paramValue, (String)aesKey);
        }
        return null;
    }

    private void updateRequestParam(ServerWebExchange exchange, String param) throws Exception {
        if (StrUtil.isBlank((CharSequence)param)) {
            return;
        }
        ServerHttpRequest request = exchange.getRequest();
        URI uri = request.getURI();
        Field targetQuery = uri.getClass().getDeclaredField("query");
        targetQuery.setAccessible(true);
        targetQuery.set(uri, param);
    }

    static class RequestDecryptRewriter
    implements RewriteFunction<byte[], byte[]> {
        RequestDecryptRewriter() {
        }

        public Publisher<byte[]> apply(ServerWebExchange exchange, byte[] bytes) {
            return Mono.just((Object)this.decrypt(exchange, bytes));
        }

        public byte[] decrypt(ServerWebExchange exchange, byte[] bytes) {
            String decryptResult;
            String aesKey = (String)exchange.getAttribute("aesKey");
            if (bytes == null || bytes.length == 0 || StrUtil.isBlank((CharSequence)aesKey)) {
                return bytes;
            }
            String requestUri = exchange.getRequest().getURI().getPath();
            String text = new String(bytes);
            try {
                decryptResult = ApiEncryptUtil.aesDecrypt((String)text, (String)aesKey);
            }
            catch (Exception e) {
                throw new ApiDecryptException(requestUri, text, aesKey, (Throwable)e);
            }
            return decryptResult.getBytes(StandardCharsets.UTF_8);
        }
    }
}

