/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.filter.request;

import cn.futuai.open.encrypt.core.exception.ApiTimestampException;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import cn.futuai.open.encrypt.spring.boot.filter.AbstractApiFilter;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestApiTimestampVerifyFilter
extends AbstractApiFilter {
    @Resource
    private ApiEncryptProperties apiEncryptProperty;

    @Override
    protected ApiEncryptProperties getApiEncryptProperty() {
        return this.apiEncryptProperty;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String requestUri = request.getRequestURI();
        String timestampStr = (String)request.getAttribute("timestamp");
        if (StrUtil.isBlankIfStr((Object)timestampStr) || !StrUtil.isNumeric((CharSequence)timestampStr)) {
            throw new ApiTimestampException(requestUri, timestampStr);
        }
        long timestamp = Long.parseLong(timestampStr);
        if (!ApiEncryptUtil.isTimestampValid((long)timestamp, (long)this.apiEncryptProperty.getTimestamp().getTimestampValidSecond())) {
            throw new ApiTimestampException(requestUri, timestampStr);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

