/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.filter.request;

import cn.futuai.open.encrypt.core.HttpEncryptRequestWrapper;
import cn.futuai.open.encrypt.core.exception.ApiDecryptException;
import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.property.RequestDecrypt;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import cn.futuai.open.encrypt.spring.boot.filter.AbstractApiFilter;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestApiDecryptFilter
extends AbstractApiFilter {
    @Resource
    private ApiEncryptProperties apiEncryptProperty;

    @Override
    protected ApiEncryptProperties getApiEncryptProperty() {
        return this.apiEncryptProperty;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws ServletException, IOException {
        RequestDecrypt requestDecrypt;
        String requestUri = req.getRequestURI();
        if (ApiChecker.isPass((String)requestUri, (Boolean)(requestDecrypt = this.apiEncryptProperty.getRequestDecrypt()).getEnabled(), (CheckModel)requestDecrypt.getCheckModel())) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        HttpEncryptRequestWrapper requestWrapper = new HttpEncryptRequestWrapper(req);
        String queryString = (String)requestWrapper.getAttribute("orgQueryString");
        String aesKey = (String)requestWrapper.getAttribute("aesKey");
        try {
            Map<String, String> decryptRequestParam = this.decryptRequestParam(queryString, aesKey);
            this.updateRequestParam(requestWrapper, decryptRequestParam);
        }
        catch (Exception e) {
            throw new ApiDecryptException(requestUri, queryString, aesKey, (Throwable)e);
        }
        String orgBody = (String)requestWrapper.getAttribute("orgBody");
        if (StrUtil.isBlank((CharSequence)orgBody)) {
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)resp);
            return;
        }
        try {
            String body = ApiEncryptUtil.aesDecrypt((String)orgBody, (String)aesKey);
            requestWrapper.setBody(body);
        }
        catch (Exception e) {
            throw new ApiDecryptException(requestUri, queryString, aesKey, (Throwable)e);
        }
        chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)resp);
    }

    private Map<String, String> decryptRequestParam(String queryString, String aesKey) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (StrUtil.isNotBlank((CharSequence)queryString) && queryString.contains(this.apiEncryptProperty.getEncryptParamKey())) {
            String[] paramsArray;
            String[] split = queryString.split("=");
            String paramValue = split[1];
            String decryptQueryString = ApiEncryptUtil.aesDecrypt((String)paramValue, (String)aesKey);
            if (StrUtil.isBlank((CharSequence)decryptQueryString)) {
                return paramMap;
            }
            for (String paramStr : paramsArray = decryptQueryString.split("&")) {
                String[] param = paramStr.split("=");
                paramMap.put(param[0], param[1]);
            }
            return paramMap;
        }
        return paramMap;
    }

    private void updateRequestParam(HttpEncryptRequestWrapper request, Map<String, String> param) {
        if (CollectionUtil.isEmpty(param)) {
            return;
        }
        request.setParameter(param);
    }
}

