/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.filter.response;

import cn.futuai.open.encrypt.core.HttpEncryptResponseWrapper;
import cn.futuai.open.encrypt.core.exception.ApiEncryptException;
import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.property.ResponseEncrypt;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import cn.futuai.open.encrypt.spring.boot.filter.AbstractApiFilter;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResponseEncryptFilter
extends AbstractApiFilter {
    @Resource
    private ApiEncryptProperties apiEncryptProperty;

    @Override
    protected ApiEncryptProperties getApiEncryptProperty() {
        return this.apiEncryptProperty;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        ResponseEncrypt responseEncrypt;
        String requestUri = request.getRequestURI();
        if (ApiChecker.isPass((String)requestUri, (Boolean)(responseEncrypt = this.apiEncryptProperty.getResponseEncrypt()).getEnabled(), (CheckModel)responseEncrypt.getCheckModel())) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        HttpEncryptResponseWrapper responseWrapper = new HttpEncryptResponseWrapper(response);
        chain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
        String aesKey = (String)request.getAttribute("aesKey");
        byte[] responseData = responseWrapper.getResponseData();
        if ("application/json".equalsIgnoreCase(responseWrapper.getContentType().trim())) {
            try {
                responseData = this.encryptResponse(responseData, aesKey, requestUri);
            }
            catch (Exception e) {
                throw new ApiEncryptException(requestUri, new String(responseData), aesKey, (Throwable)e);
            }
        }
        this.outPut(response, responseData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outPut(HttpServletResponse response, byte[] responseData) throws IOException {
        response.setContentLength(responseData.length);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(responseData);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    private byte[] encryptResponse(byte[] responseData, String aesKey, String requestUri) {
        String encryptResponse;
        String responseBody = new String(responseData);
        if (StrUtil.isNotBlank((CharSequence)responseBody) && StrUtil.isNotBlank((CharSequence)aesKey) && StrUtil.isNotBlank((CharSequence)(encryptResponse = ApiEncryptUtil.aesEncrypt((String)responseBody, (String)aesKey)))) {
            return encryptResponse.getBytes();
        }
        return responseData;
    }
}

