/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.filter.request;

import cn.futuai.open.encrypt.core.HttpEncryptRequestWrapper;
import cn.futuai.open.encrypt.core.exception.ApiBaseException;
import cn.futuai.open.encrypt.core.exception.ApiDecryptException;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import cn.futuai.open.encrypt.spring.boot.exception.ApiExceptionHandler;
import cn.futuai.open.encrypt.spring.boot.filter.AbstractApiFilter;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;

public class RequestApiFilter
extends AbstractApiFilter {
    @Resource
    private ApiEncryptProperties apiEncryptProperty;
    @Resource
    private ApiExceptionHandler apiExceptionHandler;

    @Override
    protected ApiEncryptProperties getApiEncryptProperty() {
        return this.apiEncryptProperty;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        try {
            String encryptAesKey;
            String orgQueryString;
            String timestamp;
            String requestUri = request.getRequestURI();
            String sign = request.getHeader(this.apiEncryptProperty.getSignHeaderKey());
            if (StrUtil.isNotBlank((CharSequence)sign)) {
                request.setAttribute("sign", (Object)sign);
            }
            if (StrUtil.isNotBlank((CharSequence)(timestamp = request.getHeader(this.apiEncryptProperty.getTimestampHeaderKey())))) {
                request.setAttribute("timestamp", (Object)timestamp);
            }
            if (StrUtil.isNotBlank((CharSequence)(orgQueryString = request.getQueryString()))) {
                request.setAttribute("orgQueryString", (Object)orgQueryString);
            }
            if (StrUtil.isNotBlank((CharSequence)(encryptAesKey = request.getHeader(this.apiEncryptProperty.getEncryptAesKeyHeaderKey())))) {
                try {
                    String aseKey = ApiEncryptUtil.rsaDecrypt((String)encryptAesKey);
                    request.setAttribute("aesKey", (Object)aseKey);
                }
                catch (Exception e) {
                    throw new ApiDecryptException(requestUri, encryptAesKey, "", (Throwable)e);
                }
            }
            if (Objects.equals(request.getMethod(), HttpMethod.GET.name())) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            HttpEncryptRequestWrapper requestWrapper = new HttpEncryptRequestWrapper(request);
            String body = requestWrapper.getBody();
            if (StrUtil.isNotBlank((CharSequence)body)) {
                requestWrapper.setAttribute("orgBody", (Object)body);
            }
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)response);
        }
        catch (ApiBaseException e) {
            this.apiExceptionHandler.apiExceptionHandler(request, response, e);
        }
    }
}

