/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.config;

import cn.futuai.open.encrypt.core.log.ApiEncryptLogger;
import cn.futuai.open.encrypt.core.log.DefaultApiEncryptLogger;
import cn.futuai.open.encrypt.core.property.BaseApiEncryptProperties;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import cn.futuai.open.encrypt.spring.boot.exception.ApiExceptionHandler;
import cn.futuai.open.encrypt.spring.boot.filter.request.RequestApiDecryptFilter;
import cn.futuai.open.encrypt.spring.boot.filter.request.RequestApiFilter;
import cn.futuai.open.encrypt.spring.boot.filter.request.RequestApiSignVerifyFilter;
import cn.futuai.open.encrypt.spring.boot.filter.request.RequestApiTimestampVerifyFilter;
import cn.futuai.open.encrypt.spring.boot.filter.response.ResponseEncryptFilter;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@ConditionalOnProperty(name={"spring.api-encrypt.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={ApiEncryptProperties.class})
public class ApiEncryptAutoConfiguration {
    private final ApiEncryptProperties apiEncryptProperties;

    public ApiEncryptAutoConfiguration(ApiEncryptProperties apiEncryptProperties) {
        this.apiEncryptProperties = apiEncryptProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiEncryptLogger apiEncryptLogger() {
        return new DefaultApiEncryptLogger((BaseApiEncryptProperties)this.apiEncryptProperties);
    }

    @Bean
    @Order(value=-2147483648)
    public ApiExceptionHandler apiExceptionHandler(ApiEncryptLogger apiEncryptLogger) {
        return new ApiExceptionHandler(apiEncryptLogger);
    }

    @Bean
    public FilterRegistrationBean<RequestApiFilter> requestApiFilterConfig(RequestApiFilter requestApiFilter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)requestApiFilter);
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setOrder(-2147483643);
        registrationBean.setName("requestApiFilter");
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<RequestApiTimestampVerifyFilter> requestApiTimestampVerifyFilterConfig(RequestApiTimestampVerifyFilter requestApiTimestampVerifyFilter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)requestApiTimestampVerifyFilter);
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setOrder(-2147483638);
        registrationBean.setName("requestApiTimestampVerifyFilter");
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<RequestApiSignVerifyFilter> requestApiSignVerifyFilterConfig(RequestApiSignVerifyFilter requestApiSignVerifyFilter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)requestApiSignVerifyFilter);
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setOrder(-2147483628);
        registrationBean.setName("requestApiSignVerifyFilter");
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<RequestApiDecryptFilter> requestApiDecryptFilterConfig(RequestApiDecryptFilter requestApiDecryptFilter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)requestApiDecryptFilter);
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setOrder(-2147483618);
        registrationBean.setName("requestApiDecryptFilter");
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<ResponseEncryptFilter> filterConfig(ResponseEncryptFilter responseEncryptFilter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)responseEncryptFilter);
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setOrder(-2147483608);
        registrationBean.setName("responseEncryptFilter");
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestApiFilter requestApiFilter() {
        return new RequestApiFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestApiTimestampVerifyFilter requestTimestampVerifyFilter() {
        return new RequestApiTimestampVerifyFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestApiSignVerifyFilter requestSignVerifyFilter() {
        return new RequestApiSignVerifyFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestApiDecryptFilter requestDecryptFilter() {
        return new RequestApiDecryptFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    public ResponseEncryptFilter responseEncryptFilter() {
        return new ResponseEncryptFilter();
    }
}

