/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.filter;

import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractApiFilter
implements Filter {
    protected abstract ApiEncryptProperties getApiEncryptProperty();

    protected abstract void doFilterInternal(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws ServletException, IOException;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String requestUri = req.getRequestURI();
        if (ApiChecker.isPass((String)requestUri, (Boolean)this.getApiEncryptProperty().getEnabled(), (CheckModel)this.getApiEncryptProperty().getCheckModel())) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        String encryptAesKey = req.getHeader(this.getApiEncryptProperty().getEncryptAesKeyHeaderKey());
        if (ApiChecker.isTolerantRequest((String)requestUri, (List)this.getApiEncryptProperty().getTolerantUrls(), (String)encryptAesKey)) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        this.doFilterInternal(req, resp, chain);
    }
}

