/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.filter.request;

import cn.futuai.open.encrypt.core.exception.ApiTimestampException;
import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.property.TimestampVerify;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class RequestApiTimestampVerifyFilter
implements Filter {
    @Resource
    private ApiEncryptProperties apiEncryptProperty;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        String requestUri = req.getRequestURI();
        if (ApiChecker.isPass((String)requestUri, (Boolean)this.apiEncryptProperty.getEnabled(), (CheckModel)this.apiEncryptProperty.getCheckModel())) {
            chain.doFilter((ServletRequest)req, response);
            return;
        }
        TimestampVerify timestampVerify = this.apiEncryptProperty.getTimestamp();
        if (!timestampVerify.getEnabled().booleanValue()) {
            chain.doFilter(request, response);
            return;
        }
        String timestampStr = (String)req.getAttribute("timestamp");
        if (StrUtil.isBlankIfStr((Object)timestampStr) || !StrUtil.isNumeric((CharSequence)timestampStr)) {
            throw new ApiTimestampException(requestUri, timestampStr);
        }
        long timestamp = Long.parseLong(timestampStr);
        if (DateUtil.between((Date)new Date(timestamp), (Date)new Date(), (DateUnit)DateUnit.SECOND) > timestampVerify.getTimestampValidSecond()) {
            throw new ApiTimestampException(requestUri, timestampStr);
        }
        chain.doFilter((ServletRequest)req, response);
    }
}

