/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.filter.request;

import cn.futuai.open.encrypt.core.exception.ApiSignException;
import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.property.SignVerify;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class RequestApiSignVerifyFilter
implements Filter {
    @Resource
    private ApiEncryptProperties apiEncryptProperty;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        String orgBody;
        String orgQueryString;
        HttpServletRequest req = (HttpServletRequest)request;
        String requestUri = req.getRequestURI();
        if (ApiChecker.isPass((String)requestUri, (Boolean)this.apiEncryptProperty.getEnabled(), (CheckModel)this.apiEncryptProperty.getCheckModel())) {
            chain.doFilter((ServletRequest)req, response);
            return;
        }
        SignVerify signVerify = this.apiEncryptProperty.getSign();
        if (!signVerify.getEnabled().booleanValue()) {
            chain.doFilter(request, response);
            return;
        }
        String sign = (String)req.getAttribute("sign");
        String aesKey = (String)req.getAttribute("aesKey");
        String timestamp = (String)req.getAttribute("timestamp");
        if (!ApiEncryptUtil.verifySign((String)timestamp, (String)aesKey, (String)(orgQueryString = (String)req.getAttribute("orgQueryString")), (String)(orgBody = (String)req.getAttribute("orgBody")), (String)sign).booleanValue()) {
            throw new ApiSignException(requestUri, timestamp, aesKey, orgQueryString, orgBody);
        }
        chain.doFilter((ServletRequest)req, response);
    }
}

