/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.filter.request;

import cn.futuai.open.encrypt.core.HttpEncryptRequestWrapper;
import cn.futuai.open.encrypt.core.exception.ApiBaseException;
import cn.futuai.open.encrypt.core.exception.ApiDecryptException;
import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import cn.futuai.open.encrypt.spring.boot.exception.ApiExceptionHandler;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;

public class RequestApiFilter
implements Filter {
    @Resource
    private ApiEncryptProperties apiEncryptProperty;
    @Resource
    private ApiExceptionHandler apiExceptionHandler;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        try {
            String orgQueryString;
            String timestamp;
            String requestUri = req.getRequestURI();
            if (ApiChecker.isPass((String)requestUri, (Boolean)this.apiEncryptProperty.getEnabled(), (CheckModel)this.apiEncryptProperty.getCheckModel())) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            String encryptAesKey = req.getHeader(this.apiEncryptProperty.getEncryptAesKeyHeaderKey());
            String sign = req.getHeader(this.apiEncryptProperty.getSignHeaderKey());
            if (StrUtil.isNotBlank((CharSequence)sign)) {
                req.setAttribute("sign", (Object)sign);
            }
            if (StrUtil.isNotBlank((CharSequence)(timestamp = req.getHeader(this.apiEncryptProperty.getTimestampHeaderKey())))) {
                req.setAttribute("timestamp", (Object)timestamp);
            }
            if (StrUtil.isNotBlank((CharSequence)(orgQueryString = req.getQueryString()))) {
                req.setAttribute("orgQueryString", (Object)orgQueryString);
            }
            if (StrUtil.isNotBlank((CharSequence)encryptAesKey)) {
                try {
                    String aseKey = ApiEncryptUtil.rsaDecrypt((String)encryptAesKey);
                    req.setAttribute("aesKey", (Object)aseKey);
                }
                catch (Exception e) {
                    throw new ApiDecryptException(requestUri, encryptAesKey, "", (Throwable)e);
                }
            }
            if (Objects.equals(req.getMethod(), HttpMethod.GET.name())) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            HttpEncryptRequestWrapper requestWrapper = new HttpEncryptRequestWrapper(req);
            String body = requestWrapper.getBody();
            if (StrUtil.isNotBlank((CharSequence)body)) {
                requestWrapper.setAttribute("orgBody", (Object)body);
            }
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)resp);
        }
        catch (ApiBaseException e) {
            this.apiExceptionHandler.apiExceptionHandler(req, resp, e);
        }
    }
}

