/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.filter.response;

import cn.futuai.open.encrypt.core.HttpEncryptResponseWrapper;
import cn.futuai.open.encrypt.core.exception.ApiEncryptException;
import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.property.ResponseEncrypt;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseEncryptFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ResponseEncryptFilter.class);
    @Resource
    private ApiEncryptProperties apiEncryptProperty;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String requestUri = req.getRequestURI();
        if (ApiChecker.isPass((String)requestUri, (Boolean)this.apiEncryptProperty.getEnabled(), (CheckModel)this.apiEncryptProperty.getCheckModel())) {
            chain.doFilter((ServletRequest)req, response);
            return;
        }
        ResponseEncrypt responseEncrypt = this.apiEncryptProperty.getResponseEncrypt();
        if (ApiChecker.isPass((String)requestUri, (Boolean)responseEncrypt.getEnabled(), (CheckModel)responseEncrypt.getCheckModel())) {
            chain.doFilter((ServletRequest)req, response);
            return;
        }
        HttpEncryptResponseWrapper responseWrapper = new HttpEncryptResponseWrapper(resp);
        chain.doFilter((ServletRequest)req, (ServletResponse)responseWrapper);
        try {
            byte[] responseData = responseWrapper.getResponseData();
            if ("application/json".equalsIgnoreCase(responseWrapper.getContentType().trim())) {
                String aesKey = (String)request.getAttribute("aesKey");
                responseData = this.encryptResponse(responseData, aesKey);
            }
            this.outPut(response, responseData);
        }
        catch (Exception e) {
            log.error("\u54cd\u5e94\u7ed3\u679c\u52a0\u5bc6\u5f02\u5e38,requestUri:{}", (Object)requestUri, (Object)e);
            throw new ApiEncryptException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outPut(ServletResponse response, byte[] responseData) throws IOException {
        response.setContentLength(responseData.length);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(responseData);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public byte[] encryptResponse(byte[] responseData, String aesKey) {
        String encryptResponse;
        String responseBody = new String(responseData, StandardCharsets.UTF_8);
        if (StrUtil.isNotBlank((CharSequence)responseBody) && StrUtil.isNotBlank((CharSequence)aesKey) && StrUtil.isNotBlank((CharSequence)(encryptResponse = ApiEncryptUtil.aesEncrypt((String)responseBody, (String)aesKey)))) {
            return encryptResponse.getBytes(StandardCharsets.UTF_8);
        }
        return responseData;
    }
}

