/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.filter.request;

import cn.futuai.open.encrypt.core.exception.ApiTimestampException;
import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.property.TimestampVerify;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestApiTimestampVerifyFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RequestApiTimestampVerifyFilter.class);
    @Resource
    private ApiEncryptProperties apiEncryptProperty;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletRequest req = (HttpServletRequest)request;
        String requestUri = req.getRequestURI();
        if (ApiChecker.isPass((String)requestUri, (Boolean)this.apiEncryptProperty.getEnabled(), (CheckModel)this.apiEncryptProperty.getCheckModel())) {
            chain.doFilter((ServletRequest)req, response);
            return;
        }
        TimestampVerify timestampVerify = this.apiEncryptProperty.getTimestamp();
        if (!timestampVerify.getEnabled().booleanValue()) {
            chain.doFilter(request, response);
            return;
        }
        String timestampStr = (String)req.getAttribute("timestamp");
        if (StrUtil.isBlankIfStr((Object)timestampStr) || !StrUtil.isNumeric((CharSequence)timestampStr)) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u65f6\u95f4\u6233\u683c\u5f0f\u4e0d\u6b63\u786e,requestUri:{}, timestamp:{}", (Object)requestUri, (Object)timestampStr);
            throw new ApiTimestampException();
        }
        long timestamp = Long.parseLong(timestampStr);
        if (DateUtil.between((Date)new Date(timestamp), (Date)new Date(), (DateUnit)DateUnit.SECOND) > timestampVerify.getTimestampValidSecond()) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u65f6\u95f4\u6233\u6821\u9a8c\u5931\u8d25,requestUri:{}, timestamp:{}", (Object)requestUri, (Object)timestamp);
            throw new ApiTimestampException();
        }
        chain.doFilter((ServletRequest)req, response);
    }
}

