/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.filter.request;

import cn.futuai.open.encrypt.core.exception.ApiSignException;
import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.property.SignVerify;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestApiSignVerifyFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RequestApiSignVerifyFilter.class);
    @Resource
    private ApiEncryptProperties apiEncryptProperty;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        String orgBody;
        String orgQueryString;
        HttpServletRequest req = (HttpServletRequest)request;
        String requestUri = req.getRequestURI();
        if (ApiChecker.isPass((String)requestUri, (Boolean)this.apiEncryptProperty.getEnabled(), (CheckModel)this.apiEncryptProperty.getCheckModel())) {
            chain.doFilter((ServletRequest)req, response);
            return;
        }
        SignVerify signVerify = this.apiEncryptProperty.getSign();
        if (!signVerify.getEnabled().booleanValue()) {
            chain.doFilter(request, response);
            return;
        }
        String sign = (String)req.getAttribute("sign");
        String aesKey = (String)req.getAttribute("aesKey");
        String timestamp = (String)req.getAttribute("timestamp");
        if (!ApiEncryptUtil.verifySign((String)timestamp, (String)aesKey, (String)(orgQueryString = (String)req.getAttribute("orgQueryString")), (String)(orgBody = (String)req.getAttribute("orgBody")), (String)sign).booleanValue()) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u9a8c\u7b7e\u5931\u8d25,requestUri:{}, timestamp:{}, aesKey:{}, orgQueryString:{}, orgBody:{}, sign:{}", new Object[]{requestUri, timestamp, aesKey, orgQueryString, orgBody, sign});
            throw new ApiSignException();
        }
        chain.doFilter((ServletRequest)req, response);
    }
}

