/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.filter.request;

import cn.futuai.open.encrypt.core.HttpEncryptRequestWrapper;
import cn.futuai.open.encrypt.core.exception.ApiBaseException;
import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import cn.futuai.open.encrypt.spring.boot.exception.ApiExceptionHandler;
import cn.hutool.core.util.StrUtil;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class RequestApiFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RequestApiFilter.class);
    @Resource
    private ApiEncryptProperties apiEncryptProperty;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        try {
            String orgQueryString;
            String timestamp;
            String requestUri = req.getRequestURI();
            if (ApiChecker.isPass((String)requestUri, (Boolean)this.apiEncryptProperty.getEnabled(), (CheckModel)this.apiEncryptProperty.getCheckModel())) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            String encryptAesKey = req.getHeader(this.apiEncryptProperty.getEncryptAesKeyHeaderKey());
            String sign = req.getHeader(this.apiEncryptProperty.getSignHeaderKey());
            if (StrUtil.isNotBlank((CharSequence)sign)) {
                req.setAttribute("sign", (Object)sign);
            }
            if (StrUtil.isNotBlank((CharSequence)(timestamp = req.getHeader(this.apiEncryptProperty.getTimestampHeaderKey())))) {
                req.setAttribute("timestamp", (Object)timestamp);
            }
            if (StrUtil.isNotBlank((CharSequence)(orgQueryString = req.getQueryString()))) {
                req.setAttribute("orgQueryString", (Object)orgQueryString);
            }
            if (StrUtil.isNotBlank((CharSequence)encryptAesKey)) {
                try {
                    String aseKey = ApiEncryptUtil.rsaDecrypt((String)encryptAesKey);
                    req.setAttribute("aesKey", (Object)aseKey);
                }
                catch (Exception e) {
                    log.error("\u5bf9\u79f0\u52a0\u5bc6\u5bc6\u94a5\u89e3\u5bc6\u5931\u8d25,requestUri:{},encryptAesKey:{}", new Object[]{requestUri, encryptAesKey, e});
                    throw new ApiBaseException();
                }
            }
            if (Objects.equals(req.getMethod(), HttpMethod.GET.name())) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            HttpEncryptRequestWrapper requestWrapper = new HttpEncryptRequestWrapper(req);
            String body = requestWrapper.getBody();
            if (StrUtil.isNotBlank((CharSequence)body)) {
                requestWrapper.setAttribute("orgBody", (Object)body);
            }
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)resp);
        }
        catch (ApiBaseException e) {
            ApiExceptionHandler.apiExceptionHandler(req, resp, e);
        }
    }
}

