/*
 * Decompiled with CFR 0.152.
 */
package cn.futuai.open.encrypt.spring.boot.filter.request;

import cn.futuai.open.encrypt.core.HttpEncryptRequestWrapper;
import cn.futuai.open.encrypt.core.exception.ApiDecryptException;
import cn.futuai.open.encrypt.core.property.CheckModel;
import cn.futuai.open.encrypt.core.property.RequestDecrypt;
import cn.futuai.open.encrypt.core.util.ApiChecker;
import cn.futuai.open.encrypt.core.util.ApiEncryptUtil;
import cn.futuai.open.encrypt.spring.boot.config.property.ApiEncryptProperties;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestApiDecryptFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RequestApiDecryptFilter.class);
    @Resource
    private ApiEncryptProperties apiEncryptProperty;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String requestUri = req.getRequestURI();
        if (ApiChecker.isPass((String)requestUri, (Boolean)this.apiEncryptProperty.getEnabled(), (CheckModel)this.apiEncryptProperty.getCheckModel())) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        RequestDecrypt requestDecrypt = this.apiEncryptProperty.getRequestDecrypt();
        if (ApiChecker.isPass((String)requestUri, (Boolean)requestDecrypt.getEnabled(), (CheckModel)requestDecrypt.getCheckModel())) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        HttpEncryptRequestWrapper requestWrapper = new HttpEncryptRequestWrapper(req);
        String queryString = (String)requestWrapper.getAttribute("orgQueryString");
        String aesKey = (String)requestWrapper.getAttribute("aesKey");
        try {
            Map<String, String> decryptRequestParam = this.decryptRequestParam(queryString, aesKey);
            this.updateRequestParam(requestWrapper, decryptRequestParam);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38,requestUri:{}, queryString:{}, aesKey:{}", new Object[]{requestUri, queryString, aesKey, e});
            throw new ApiDecryptException();
        }
        String orgBody = (String)requestWrapper.getAttribute("orgBody");
        if (StrUtil.isBlank((CharSequence)orgBody)) {
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)resp);
            return;
        }
        try {
            String body = ApiEncryptUtil.aesDecrypt((String)orgBody, (String)aesKey);
            requestWrapper.setBody(body);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6body\u53c2\u6570\u5f02\u5e38,requestUri:{}, orgBody:{}, aesKey:{}", new Object[]{requestUri, orgBody, aesKey, e});
            throw new ApiDecryptException();
        }
        chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)resp);
    }

    private Map<String, String> decryptRequestParam(String queryString, String aesKey) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (StrUtil.isNotBlank((CharSequence)queryString) && queryString.contains(this.apiEncryptProperty.getEncryptParamKey())) {
            String[] paramsArray;
            String[] split = queryString.split("=");
            String paramValue = split[1];
            String decryptQueryString = ApiEncryptUtil.aesDecrypt((String)paramValue, (String)aesKey);
            if (StrUtil.isBlank((CharSequence)decryptQueryString)) {
                return paramMap;
            }
            for (String paramStr : paramsArray = decryptQueryString.split("&")) {
                String[] param = paramStr.split("=");
                paramMap.put(param[0], param[1]);
            }
            return paramMap;
        }
        return paramMap;
    }

    private void updateRequestParam(HttpEncryptRequestWrapper request, Map<String, String> param) {
        if (CollectionUtil.isEmpty(param)) {
            return;
        }
        try {
            request.setParameter(param);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38, param:{}", param, (Object)e);
            throw new ApiDecryptException();
        }
    }
}

