package cn.funnymap.lgis.vector.generator.wkt;

import cn.funnymap.lgis.vector.generator.ShpField;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

import java.util.HashMap;
import java.util.List;

/**
 * 数据转换器参数
 *
 * @author jiaoxn
 */
public class Wkt2ShpGeneratorParam {
    private final CoordinateReferenceSystem crs;
    private final List<String> wktList;
    private final List<HashMap<String, Object>> attrValueList;
    private final List<ShpField> fieldList;

    public Wkt2ShpGeneratorParam(CoordinateReferenceSystem crs,
                                 List<ShpField> fieldList,
                                 List<String> wktList,
                                 List<HashMap<String, Object>> attrValueList) {
        this.crs = crs;
        this.fieldList = fieldList;
        this.wktList = wktList;
        this.attrValueList = attrValueList;
    }

    public List<HashMap<String, Object>> getAttrValueList() {
        return attrValueList;
    }

    public List<ShpField> getFieldList() {
        return fieldList;
    }

    public CoordinateReferenceSystem getCrs() {
        return crs;
    }

    public List<String> getWktList() {
        return wktList;
    }
}
