package cn.funnymap.lgis.vector.generator.graphic;

import cn.funnymap.lgis.vector.generator.ShpField;
import com.alibaba.fastjson2.JSONArray;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

import java.util.List;

/**
 * GeoJSON-Shapefile生成器输入参数
 *
 * @author jiaoxn
 */
public class EsriGraphic2ShpGeneratorParam {
    private final CoordinateReferenceSystem crs;
    private final JSONArray geojsonList;
    private final List<ShpField> fieldList;

    public EsriGraphic2ShpGeneratorParam(CoordinateReferenceSystem crs, JSONArray geojsonList, List<ShpField> fieldList) {
        this.crs = crs;
        this.geojsonList = geojsonList;
        this.fieldList = fieldList;
    }

    public CoordinateReferenceSystem getCrs() {
        return crs;
    }

    public JSONArray getGeojsonList() {
        return geojsonList;
    }

    public List<ShpField> getFieldList() {
        return fieldList;
    }
}
