package cn.funnymap.lgis.vector.generator;

import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

import java.util.HashMap;
import java.util.List;

/**
 * 中间类，存储WKT的属性及空间信息
 *
 * @author jiaoxn
 */
public class GeneratorContent {
    private final CoordinateReferenceSystem crs;
    private final List<ShpField> fieldList;
    private final List<HashMap<String, Object>> valueList;
    private List<Geometry> geometryList;

    public GeneratorContent(List<Geometry> geometryList,
                            List<ShpField> fieldList,
                            List<HashMap<String, Object>> valueList,
                            CoordinateReferenceSystem crs) {
        this.geometryList = geometryList;
        this.fieldList = fieldList;
        this.valueList = valueList;
        this.crs= crs;
    }

    public List<ShpField> getFieldList() {
        return fieldList;
    }

    public List<HashMap<String, Object>> getValueList() {
        return valueList;
    }

    public CoordinateReferenceSystem getCrs() {
        return crs;
    }

    public List<Geometry> getGeometryList() {
        return geometryList;
    }

    public void setGeometryList(List<Geometry> geometryList) {
        this.geometryList = geometryList;
    }
}
