package cn.funnymap.lgis.util;

import org.apache.commons.lang3.time.DateUtils;

import java.text.ParseException;
import java.util.Date;

/**
 * 日期工具类
 *
 * @author jiaoxn
 */
public class DateUtil {
    private DateUtil() {}

    private static final String[] DATE_PARSE_PATTERNS = {"yyyy-MM-dd","yyyy年MM月dd日"};

    public static Date parse(String value) {
        if (value == null) {
            return null;
        }

        try {
            return DateUtils.parseDate(value, DATE_PARSE_PATTERNS);
        } catch (ParseException exception) {
            return null;
        }
    }
}
