package cn.funnymap.lgis.crs;

import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/**
 * 地理坐标参考系统
 *
 * @author jiaoxn
 */
public class GeographicCRS implements CRS {
    private GeographicCRS() {}

    public static final DefaultGeographicCRS WGS84;
    public static final CoordinateReferenceSystem CGCS2000;

    static {
        WGS84 = DefaultGeographicCRS.WGS84;
        try {
            CGCS2000 = org.geotools.referencing.CRS.decode("EPSG:4490");
        } catch (FactoryException e) {
            throw new RuntimeException(e);
        }
    }
}
