package cn.funnymap.lgis.vector.converter.wkt2shp;

import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

import java.util.List;
import java.util.SortedMap;

/**
 * 中间类，存储WKT的属性及空间信息
 *
 * @author jiaoxn
 */
class WKTContent {
    private final CoordinateReferenceSystem crs;
    private final List<String> wktList;
    private final SortedMap<String, Class<?>> attribute;
    private final List<SortedMap<String, Object>> valueList;
    private List<Geometry> geometryList;

    public WKTContent(List<String> wktList,
                      SortedMap<String, Class<?>> attribute,
                      List<SortedMap<String, Object>> valueList,
                      CoordinateReferenceSystem crs) {
        this.wktList = wktList;
        this.attribute = attribute;
        this.valueList = valueList;
        this.crs= crs;
    }

    public List<String> getWktList() {
        return wktList;
    }

    public SortedMap<String, Class<?>> getAttribute() {
        return attribute;
    }

    public List<SortedMap<String, Object>> getValueList() {
        return valueList;
    }

    public CoordinateReferenceSystem getCrs() {
        return crs;
    }

    public List<Geometry> getGeometryList() {
        return geometryList;
    }

    public void setGeometryList(List<Geometry> geometryList) {
        this.geometryList = geometryList;
    }
}
