package cn.funnymap.lgis.vector;

import cn.funnymap.lgis.vector.params.GeojsonResponse;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

import java.nio.file.Path;
import java.util.List;

/**
 * 空间文件
 *
 * @author jiaoxn
 */
public abstract class VectorFile {
    static {
        System.setProperty("org.geotools.referencing.forceXY", "true");
    }

    protected abstract void executeValidityVerification(Path path);

    public String parseAsWkt(Path path, CoordinateReferenceSystem targetCrs) {
        this.executeValidityVerification(path);
        String wkt = this.parseAsWktExecutor(targetCrs);
        this.deleteTempDir();
        return wkt;
    }

    public List<GeojsonResponse> parseAsGeojson(Path path, CoordinateReferenceSystem targetCrs) {
        this.executeValidityVerification(path);
        List<GeojsonResponse> geojsonResponseList = this.parseAsGeojsonExecutor(targetCrs);
        this.deleteTempDir();
        return geojsonResponseList;
    }

    /**
     * 将Shapefile文件转为WKT格式并输出
     *
     * @return WKT格式内容
     */
    public abstract String parseAsWktExecutor(CoordinateReferenceSystem targetCrs);

    /**
     * 将Shapefile文件解析为GeoJSON格式并输出
     *
     * @return GeoJSON格式内容
     */
    public abstract List<GeojsonResponse> parseAsGeojsonExecutor(CoordinateReferenceSystem targetCrs);

    protected abstract void deleteTempDir();
}
